<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | File name : calendar.php                                         		  |
// | PHP version >= 5.2                                                   |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ï¿½ 2010                                    |
// | All rights reserved                                                  |
// +----------------------------------------------------------------------+
// | This script may not be distributed, sold, given away for free to     |
// | third party, or used as a part of any internet services such as      |
// | webdesign etc.                                                       |
// +----------------------------------------------------------------------+

/*
 * this class is for calendar
*/

class Calendar {

    public static function loadJsFiles() {
      
        PageContext::addScript('calendar/Common.js');
        PageContext::addScript('calendar/datepicker_lang_US.js');
        //PageContext::addScript('calendar/jquery.datepicker.js');
        PageContext::addScript('calendar/jquery.alert.js');
        PageContext::addScript('calendar/jquery.ifrmdailog.js');
        PageContext::addScript('calendar/wdCalendar_lang_US.js');
        PageContext::addScript('calendar/jquery.calendar.js');
        PageContext::addScript('calendar/calendar_exe.js');
    }

    public static function loadCssFiles() {

        PageContext::addStyle("calendar/dailog.css",true);
        PageContext::addStyle("calendar/calendar.css",true);
        PageContext::addStyle("calendar/dp.css",true);
        PageContext::addStyle("calendar/alert.css",true);
        PageContext::addStyle("calendar/main.css",true);
    }

    public function addCalendar($id,$st, $et, $ade) {
        $ret = array();
        $addFlag = 0;
        try {
            $db = new Db();
            $startTime = date("H:i",strtotime($st));
            $endTime   = date("H:i",strtotime($et));
            $startDate = Calendar::php2MySqlTime(Calendar::js2PhpTime($st));
            $endDate   = Calendar::php2MySqlTime(Calendar::js2PhpTime($et));

            $lastKey = array_pop(array_keys($_SESSION['cellDetails']));
            $newKey = $lastKey+1;
            if(!empty($lastKey)) $key = $newKey; else $key = 1;
            $addData = self::addDataToSession($key,$id,$startDate,$endDate,$startTime,$endTime);
            $addFlag = 1;
            //echo 'Last Session : '; echopre($_SESSION['cellDetails']);

            /*
            $sql = "insert into jqcalendar (classId,StartDate,EndDate,StartTime,EndTime,IsAllDayEvent,IsRepeat) values ('"
                    .$classId."', '"
                    .Calendar::php2MySqlTime(Calendar::js2PhpTime($st))."', '"
                    .Calendar::php2MySqlTime(Calendar::js2PhpTime($et))."', '"
                    .$startTime."', '"
                    .$endTime."', '"
                    .mysql_real_escape_string($ade)."', 0 )";

            */
            //echo($sql);
            if($addFlag==1 && $key >0 ) {
                $ret['IsSuccess'] = true;
                $ret['Msg'] = 'add success';
                $ret['Data'] =$key;
            }else {
                $ret['IsSuccess'] = false;
                $ret['Msg'] = mysql_error();
                //$ret['Data'] = mysql_insert_id();
            }
        }catch(Exception $e) {
            $ret['IsSuccess'] = false;
            $ret['Msg'] = $e->getMessage();
        }
        return $ret;
    }

    public function addDetailedCalendar($st, $et, $sub, $ade, $dscr, $loc, $color, $tz) {
        $ret = array();
        try {
            $db = new Db();
            $sql = "insert into `jqcalendar` (`subject`, `starttime`, `endtime`, `isalldayevent`, `description`, `location`, `color`) values ('"
                    .mysql_real_escape_string($sub)."', '"
                    .Calendar::php2MySqlTime(Calendar::js2PhpTime($st))."', '"
                    .Calendar::php2MySqlTime(Calendar::js2PhpTime($et))."', '"
                    .mysql_real_escape_string($ade)."', '"
                    .mysql_real_escape_string($dscr)."', '"
                    .mysql_real_escape_string($loc)."', '"
                    .mysql_real_escape_string($color)."' )";
            //echo($sql);
            if(mysql_query($sql)==false) {
                $ret['IsSuccess'] = false;
                $ret['Msg'] = mysql_error();
            }else {
                $ret['IsSuccess'] = true;
                $ret['Msg'] = 'add success';
                $ret['Data'] = mysql_insert_id();
            }
        }catch(Exception $e) {
            $ret['IsSuccess'] = false;
            $ret['Msg'] = $e->getMessage();
        }
        return $ret;
    }



    public function listCalendarByRangeBkp($sd, $ed, $locationId,$displayType) {
        
        $arrayData                 = array();
        $ret                       = array();
        $ret['events']             = array();
        $ret["issort"]             = true;
        $ret["start"]              = Calendar::php2JsTime($sd);
        $ret["end"]                = Calendar::php2JsTime($ed);
        $ret['error']              = null;
        try {
            $db = new Db();

           $sql = " SELECT B.*,DATE_FORMAT(B.dArrival_Date,'%m/%d/%Y') as start_date,DATE_FORMAT( DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as end_date,
                            '0:00' as start_time , '23:59' as end_time
                     FROM ".MYSQL_TABLE_PREFIX."locations L
		     INNER JOIN ".MYSQL_TABLE_PREFIX."available_acco_type AAT ON AAT.nLocation_Id = L.nLocation_Id
		     INNER JOIN ".MYSQL_TABLE_PREFIX."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
                     INNER JOIN ".MYSQL_TABLE_PREFIX."booking B ON B.nBooking_Id = AAT.nAat_Id

		     WHERE AAT.vActive='active' AND L.nLocation_Id = '".mysql_real_escape_string($locationId)."' AND AT.vActive='active'
                     AND DATE_FORMAT(B.dArrival_Date,'%H:%i') between '" .$startTime."' and '". $endTime."'
                     GROUP BY AT.nAt_Id";


            $handle = mysql_query($sql);

            while ($row = mysql_fetch_object($handle)) {

                $title = '';
                $numberOfAdults   = ($row->nAdults>0) ? $row->nAdults : 1;
                $numberOfChildren = ($row->nChildren>0) ? $row->nChildren : 0;
                $numberOfNights   = ($row->nNights_Stay>0) ? $row->nNights_Stay : 1;
                $title .='';
                $title .='Confirmed';

                if(rand(0,10) > 8){
                    $alld = 1;
                }else{
                    $alld=0;
                }


                $te= rand(-1,13);

                $arrayData[] = array(
                                      rand(10000, 99999),
                                      'booked',
                                      Calendar::php2JsTime(Calendar::mySql2PhpTime($row->start_date.' '.$row->start_time)),
                                      Calendar::php2JsTime(Calendar::mySql2PhpTime($row->end_date.' '.$row->end_time)),
                                      rand(0,1),
                                      0, //more than one day event
                                        //$row->InstanceType,
                                      0,//Recurring event,
                                      '',//color
                                      1,//editable
                                      '',
                                      ''//$attends
                                    );
            }



            if(!empty($arrayData)){
             $ret['events'] = $arrayData;
            }

            //echo '<pre>';print_r($ret['events']);echo '</pre>'; exit;
        }catch(Exception $e) {
            $ret['error'] = $e->getMessage();
        }
        return $ret;
    }

    public function listCalendarByRange($sd, $ed, $locationId,$displayType,$category,$accomodatin,$numberOfPeople,$numberOfRooms,$startingPrice) {

        $arrayData                 = array();
        $ret                       = array();
        $ret['events']             = array();
        $ret["issort"]             = true;
        $ret["start"]              = Calendar::php2JsTime($sd);  //echopre($ret["start"]);
        $ret["end"]                = Calendar::php2JsTime($ed);  //echopre($ret["end"]);
        $ret['error']              = null;
        try {
            $db = new Db();
            $startTime = date("H:i",$sd);
            $endTime   = date("H:i",$ed); 
            
            $bookingData = Booking::getMonthPrices($locationId,$accomodatin,$numberOfPeople,$ret["start"],$ret["end"],$startingPrice,$numberOfRooms);
            //echopre1($bookingData);
            $nextDay = date('m/d/Y', strtotime($ret["start"]));
            while(strtotime($nextDay) < strtotime($ret["end"])) {

                if($bookingData[$nextDay]['price']>0)
                $tempPrice = '$'.$bookingData[$nextDay]['price'];
               
                else
                $tempPrice = 'N/A';

                $status = $bookingData[$nextDay]['status'];
                $rsd = rand($sd, $ed);
                $red = rand(3600, 10800);
                $arrayData[] = array(
                                      rand(10000, 99999),
                                      $tempPrice,
                                      $nextDay,
                                      $nextDay,
                                      1,
                                      0, //more than one day event
                                      0,//Recurring event,
                                      0,
                                      0,//editable
                                      '',
                                      '',//$attends
                                      $status
                                    ); //echo '<pre>';print_r($arrayData);echo '</pre>'; exit;
                $nextDay = date('m/d/Y', strtotime('+1 day', strtotime($nextDay)));
            }



            if(!empty($arrayData)){
             $ret['events'] = $arrayData;
            }

            //echo '<pre>';print_r($ret['events']);echo '</pre>'; exit;
        }catch(Exception $e) {
            $ret['error'] = $e->getMessage();
        }
        return $ret;
    }

    
    public function listReportCalendarByRange($sd, $ed, $requestData,$displayType) {
        
        $locationId = $requestData['location'];
        $aatId = $requestData['accomodation'];
        $arrayData                 = array();
        $arrayDataFromSession      = array();
        $ret                       = array();
        $ret['events']             = array();
        $ret["issort"]             = true;
        $ret["start"]              = Calendar::php2JsTime($sd);
        $ret["end"]                = Calendar::php2JsTime($ed);
        $ret['error']              = null;
        try {
            $db = new Db();


            


            $startTime = date("H:i",$sd);
            $endTime   = date("H:i",$ed);

         

           $sql = " SELECT B.*,DATE_FORMAT(B.dArrival_Date,'%m/%d/%Y') as start_date,DATE_FORMAT( DATE_ADD(dArrival_Date, INTERVAL nNights_Stay DAY),'%m/%d/%Y') as end_date,
                            '0:00' as start_time , '23:59' as end_time
                     from
		    ".MYSQL_TABLE_PREFIX."available_acco_type AAT 
		     INNER JOIN ".MYSQL_TABLE_PREFIX."accomodation_types AT ON AT.nAt_Id = AAT.nAt_Id
                         INNER JOIN ".MYSQL_TABLE_PREFIX."allotment A ON AAT.nAat_Id = A.nAat_Id
                     INNER JOIN ".MYSQL_TABLE_PREFIX."booking B ON B.nBooking_Id = A.nBooking_Id

		     WHERE AAT.vActive='active' AND AAT.nLocation_Id = '".mysql_real_escape_string($locationId)."'  AND AAT.nAt_Id = $aatId
                    ";

            $handle = mysql_query($sql);

            while ($row = mysql_fetch_object($handle))
            {


                $title = '';

                $numberOfAdults   = ($row->nAdults>0) ? $row->nAdults : 1;
                $numberOfChildren = ($row->nChildren>0) ? $row->nChildren : 0;
                $numberOfNights   = ($row->nNights_Stay>0) ? $row->nNights_Stay : 1;

                $title .='';
                $title .='Confirmed';
               


                if(rand(0,10) > 8){
                    $alld = 1;
                }else{
                    $alld=0;
                }


                $te= rand(-1,13);

                $arrayData[] = array(
                                      rand(10000, 99999),
                                      'booked',
                                      Calendar::php2JsTime(Calendar::mySql2PhpTime($row->start_date.' '.$row->start_time)),
                                      Calendar::php2JsTime(Calendar::mySql2PhpTime($row->end_date.' '.$row->end_time)),
                                      rand(0,1),
                                      0, //more than one day event
                                        //$row->InstanceType,
                                      0,//Recurring event,
                                      '',//color
                                      0,//editable
                                      '',
                                      ''//$attends
                                    );
            }



            if(!empty($arrayData)){
             $ret['events'] = $arrayData;
            }

            //echo '<pre>';print_r($ret['events']);echo '</pre>'; exit;
        }catch(Exception $e) {
            $ret['error'] = $e->getMessage();
        }
        return $ret;




    }

    public function listCalendar($day, $type, $requestData, $displayType, $category,$accomodatin,$numberOfPeople,$numberOfRooms,$startingPrice) {


      
        
        $phpTime = Calendar::js2PhpTime($day);

  //echo $phpTime . "+" . $type;
    switch($type){
    case "month":
      $st = mktime(0, 0, 0, date("m", $phpTime), 1, date("Y", $phpTime));
      $et = mktime(0, 0, -1, date("m", $phpTime)+1, 1, date("Y", $phpTime));
      $cnt = 50;
      break;
    case "week":
      //suppose first day of a week is monday
      $monday  =  date("d", $phpTime) - date('N', $phpTime) + 1;
      //echo date('N', $phpTime);
      $st = mktime(0,0,0,date("m", $phpTime), $monday, date("Y", $phpTime));
      $et = mktime(0,0,-1,date("m", $phpTime), $monday+7, date("Y", $phpTime));
      $cnt = 20;
      break;
    case "day":
      $st = mktime(0, 0, 0, date("m", $phpTime), date("d", $phpTime), date("Y", $phpTime));
      $et = mktime(0, 0, -1, date("m", $phpTime), date("d", $phpTime)+1, date("Y", $phpTime));
      $cnt = 5;
      break;
    }
  //echo $st . "--" . $et;
  
    if($category == 'report'){
        $st = $requestData['startDate'];
        $et = $requestData['endDate'];

         

        return self::listReportCalendarByRange($st, $et, $requestData,$displayType);
    }else
        return self::listCalendarByRange($st, $et, $requestData,$displayType,$category,$accomodatin,$numberOfPeople,$numberOfRooms,$startingPrice);

        //print '{"events":[[91504,"remote meeting","12\/27\/2012 23:16","01\/01\/1970 01:32",1,0,0,4,1,"Moore",""],[92537,"annual report","12\/19\/2012 21:06","01\/01\/1970 01:53",1,0,0,9,1,"Lodan",""],[42242,"go to dinner","12\/26\/2012 01:51","01\/01\/1970 02:43",0,0,0,11,1,"Belion",""],[98118,"annual report","12\/07\/2012 19:34","01\/01\/1970 01:33",1,0,0,5,1,"Newswer",""],[57666,"go to dinner","12\/19\/2012 08:12","01\/01\/1970 01:51",0,0,0,3,1,"Moore",""],[78387,"team meeting","12\/21\/2012 21:46","01\/01\/1970 01:09",1,0,0,2,1,"Moore",""],[47779,"team meeting","12\/07\/2012 18:17","01\/01\/1970 02:55",0,0,0,13,1,"Bytelin",""],[33343,"annual report","12\/31\/2012 03:44","01\/01\/1970 02:41",1,0,0,1,1,"Newswer",""],[12579,"annual report","12\/22\/2012 08:08","01\/01\/1970 01:56",1,0,0,8,1,"Newswer",""],[52986,"annual report","12\/04\/2012 13:27","01\/01\/1970 02:10",0,0,0,1,1,"Lodan",""],[42066,"annual report","12\/01\/2012 01:43","01\/01\/1970 02:53",0,1,0,5,1,"Lodan",""],[47317,"team meeting","12\/04\/2012 02:55","01\/01\/1970 01:34",1,0,0,3,1,"Lodan",""],[46241,"go to dinner","12\/05\/2012 23:03","01\/01\/1970 01:45",1,0,0,4,1,"Bytelin",""],[16336,"go to dinner","12\/29\/2012 20:08","01\/01\/1970 02:56",0,1,0,5,1,"Newswer",""],[25103,"annual report","12\/06\/2012 00:09","01\/01\/1970 02:35",1,0,0,4,1,"Lodan",""],[50042,"go to dinner","12\/19\/2012 17:06","01\/01\/1970 02:13",0,0,0,10,1,"Bytelin",""],[68653,"annual report","12\/01\/2012 04:59","01\/01\/1970 01:20",0,0,0,5,1,"Belion",""],[58435,"remote meeting","12\/04\/2012 17:49","01\/01\/1970 01:26",1,0,0,0,1,"Belion",""],[86890,"go to dinner","12\/22\/2012 13:35","01\/01\/1970 02:02",0,0,0,8,1,"Lodan",""],[41517,"team meeting","12\/15\/2012 22:17","01\/01\/1970 02:36",1,0,0,8,1,"Belion",""],[79815,"annual report","12\/08\/2012 01:55","01\/01\/1970 02:40",1,0,0,12,1,"Bytelin",""],[89285,"remote meeting","12\/22\/2012 06:30","01\/01\/1970 01:42",0,0,0,1,1,"Moore",""],[47427,"annual report","12\/19\/2012 18:00","01\/01\/1970 01:14",1,0,0,2,1,"Bytelin",""],[21741,"annual report","12\/23\/2012 18:27","01\/01\/1970 02:44",0,0,0,11,1,"Lodan",""],[79727,"team meeting","12\/26\/2012 13:51","01\/01\/1970 01:44",0,0,0,9,1,"Lodan",""],[18885,"project plan review","12\/20\/2012 10:10","01\/01\/1970 01:43",1,0,0,7,1,"Moore",""],[86714,"annual report","12\/28\/2012 13:26","01\/01\/1970 02:11",0,1,0,2,1,"Belion",""],[80716,"annual report","12\/12\/2012 05:38","01\/01\/1970 02:38",1,0,0,5,1,"Belion",""],[68389,"annual report","12\/25\/2012 16:47","01\/01\/1970 02:34",1,0,0,12,1,"Lodan",""],[27234,"team meeting","12\/30\/2012 04:51","01\/01\/1970 01:29",1,0,0,4,1,"Belion",""],[24751,"team meeting","12\/17\/2012 23:52","01\/01\/1970 02:53",0,0,0,8,1,"Lodan",""],[38440,"go to dinner","12\/12\/2012 07:49","01\/01\/1970 02:16",1,0,0,5,1,"Moore",""],[45801,"go to dinner","12\/05\/2012 10:42","01\/01\/1970 01:08",1,1,0,6,1,"Lodan",""],[24334,"team meeting","12\/20\/2012 14:32","01\/01\/1970 01:00",0,0,0,7,1,"Lodan",""],[41539,"team meeting","12\/19\/2012 01:18","01\/01\/1970 01:20",0,0,0,4,1,"Belion",""],[74915,"project plan review","12\/24\/2012 01:00","01\/01\/1970 01:39",1,0,0,10,1,"Bytelin",""],[11963,"project plan review","12\/27\/2012 19:38","01\/01\/1970 01:28",1,0,0,5,1,"Lodan",""],[10184,"project plan review","12\/22\/2012 15:13","01\/01\/1970 02:15",1,0,0,0,1,"Moore",""],[47076,"remote meeting","12\/31\/2012 17:44","01\/01\/1970 01:32",0,0,0,6,1,"Moore",""],[10140,"annual report","12\/16\/2012 09:11","01\/01\/1970 02:48",1,0,0,6,1,"Bytelin",""],[56875,"remote meeting","12\/30\/2012 19:34","01\/01\/1970 01:32",1,1,0,10,1,"Moore",""],[74783,"team meeting","12\/05\/2012 06:53","01\/01\/1970 01:16",1,0,0,-1,1,"Lodan",""],[41363,"go to dinner","12\/25\/2012 01:09","01\/01\/1970 01:29",0,0,0,-1,1,"Bytelin",""],[24114,"team meeting","12\/20\/2012 08:21","01\/01\/1970 01:41",1,0,0,8,1,"Moore",""],[90538,"annual report","12\/14\/2012 10:30","01\/01\/1970 01:22",0,1,0,5,1,"Newswer",""],[38133,"remote meeting","12\/30\/2012 13:34","01\/01\/1970 02:02",1,0,0,3,1,"Belion",""],[24400,"annual report","12\/29\/2012 23:35","01\/01\/1970 01:11",1,0,0,12,1,"Bytelin",""],[26839,"go to dinner","12\/04\/2012 22:32","01\/01\/1970 02:19",0,0,0,0,1,"Belion",""],[22950,"remote meeting","12\/09\/2012 16:25","01\/01\/1970 02:57",0,0,0,6,1,"Bytelin",""],[80232,"annual report","12\/05\/2012 11:15","01\/01\/1970 02:33",0,1,0,13,1,"Moore",""]],"issort":true,"start":"12\/01\/2012 00:00","end":"12\/31\/2012 23:59","error":null}';
    }

    public function updateCalendar($location_id,$id, $st, $et) {
        $ret = array();
        $updateFlag = 0;
        try {
            $db = new Db();
            $startTime = date("H:i",strtotime($st));
            $endTime   = date("H:i",strtotime($et));
            $startDate = Calendar::php2MySqlTime(Calendar::js2PhpTime($st));
            $endDate   = Calendar::php2MySqlTime(Calendar::js2PhpTime($et));

            // Check Schedule Exists
            $scheduleExists = Classes::checkScheduleExists($location_id,$id);

            if($scheduleExists) {
                $sql = "update tbl_class_schedules set"
                        . " start_date='" . Calendar::php2MySqlTime(Calendar::js2PhpTime($st)) . "', "
                        . " end_date='" . Calendar::php2MySqlTime(Calendar::js2PhpTime($et)) . "', "
                        . " start_time='" . $startTime . "', "
                        . " end_time='" . $endTime . "' "
                        . "where `id`=" . $id;
                $sqlRes = mysql_query($sql);
                 $updateData = self::addDataToSession($id,$location_id,$startDate,$endDate,$startTime,$endTime);
            }else{
                $updateData = self::addDataToSession($id,$location_id,$startDate,$endDate,$startTime,$endTime);
                $updateFlag = 1;
            }


            //echo $sql;
            if($sqlRes==true || $updateFlag==1 ) {
                $ret['IsSuccess'] = true;
                $ret['Msg'] = 'Succefully';
            }else {
                $ret['IsSuccess'] = false;
                $ret['Msg'] = mysql_error();
            }
        }catch(Exception $e) {
            $ret['IsSuccess'] = false;
            $ret['Msg'] = $e->getMessage();
        }
        return $ret;
    }

    public function updateDetailedCalendar($id, $st, $et, $sub, $ade, $dscr, $loc, $color, $tz) {
        $ret = array();
        try {
            $db = new Db();
            $sql = "update `jqcalendar` set"
                    . " `starttime`='" . Calendar::php2MySqlTime(Calendar::js2PhpTime($st)) . "', "
                    . " `endtime`='" . Calendar::php2MySqlTime(Calendar::js2PhpTime($et)) . "', "
                    . " `subject`='" . mysql_real_escape_string($sub) . "', "
                    . " `isalldayevent`='" . mysql_real_escape_string($ade) . "', "
                    . " `description`='" . mysql_real_escape_string($dscr) . "', "
                    . " `location`='" . mysql_real_escape_string($loc) . "', "
                    . " `color`='" . mysql_real_escape_string($color) . "' "
                    . "where `id`=" . $id;
            //echo $sql;
            if(mysql_query($sql)==false) {
                $ret['IsSuccess'] = false;
                $ret['Msg'] = mysql_error();
            }else {
                $ret['IsSuccess'] = true;
                $ret['Msg'] = 'Succefully';
            }
        }catch(Exception $e) {
            $ret['IsSuccess'] = false;
            $ret['Msg'] = $e->getMessage();
        }
        return $ret;
    }

    public function removeCalendar($classId,$id) {
        $ret = array();
        $delFlag = 0;
        try {
            $db = new Db();

            // Check Schedule Exists
            $scheduleExists = Classes::checkScheduleExists($classId,$id);

            if($scheduleExists){
                $sql = "delete from tbl_class_schedules where `id`=" . $id;
                $sqlChild = "delete from tbl_class_schedules where schedule_parent_id = ". $id;
                mysql_query($sqlChild);
                self::removeDataFromSession();
            }else{
                self::removeDataFromSession();
                $delFlag = 1;
            }

            if(mysql_query($sql)==true || $delFlag==1 ) {
                $ret['IsSuccess'] = true;
                $ret['Msg'] = 'Succefully';
            }else {
                $ret['IsSuccess'] = false;
                $ret['Msg'] = mysql_error();
            }
        }catch(Exception $e) {
            $ret['IsSuccess'] = false;
            $ret['Msg'] = $e->getMessage();
        }
        return $ret;
    }

    public function addDataToSession($id,$classId,$startDate,$endDate,$startTime,$endTime){

        $cellArray = $_SESSION['cellDetails'];
        $cellArray[$id] = array('Id'        => $id,
                                'classId'   => $classId,
                                'StartDate' => $startDate,
                                'EndDate'   => $endDate,
                                'StartTime' => $startTime,
                                'EndTime'   => $endTime );
        $_SESSION['cellDetails'] = $cellArray;
        return $_SESSION['cellDetails'];
    }

    public function removeDataFromSession(){
        foreach ($_SESSION['cellDetails'] as $key => $value) {
            if ($key == $id)
                unset($_SESSION['cellDetails'][$key]);
        }
    }


    public static function js2PhpTime($jsdate) {
        if(preg_match('@(\d+)/(\d+)/(\d+)\s+(\d+):(\d+)@', $jsdate, $matches)==1) {
            $ret = mktime($matches[4], $matches[5], 0, $matches[1], $matches[2], $matches[3]);
            //echo $matches[4] ."-". $matches[5] ."-". 0  ."-". $matches[1] ."-". $matches[2] ."-". $matches[3];
        }else if(preg_match('@(\d+)/(\d+)/(\d+)@', $jsdate, $matches)==1) {
            $ret = mktime(0, 0, 0, $matches[1], $matches[2], $matches[3]);
            //echo 0 ."-". 0 ."-". 0 ."-". $matches[1] ."-". $matches[2] ."-". $matches[3];
        }
        return $ret;
    }

    public static function php2JsTime($phpDate) {
        //echo $phpDate;
        //return "/Date(" . $phpDate*1000 . ")/";
        return date("m/d/Y H:i", $phpDate);
    }

    public static function php2MySqlTime($phpDate) {
        return date("Y-m-d H:i:s", $phpDate);
    }

    public static function mySql2PhpTime($sqlDate) {
        $arr = date_parse($sqlDate);
        return mktime($arr["hour"],$arr["minute"],$arr["second"],$arr["month"],$arr["day"],$arr["year"]);

    }

}

?>




