<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
// +----------------------------------------------------------------------+
// | This page is for user section management. Login checking , new user registration, user listing etc.                                      |
// | File name : index.php                                                  |
// | PHP version >= 5.2                                                   |
// | Created On	: 	Nov 17 2011                                               |
// +----------------------------------------------------------------------+
// +----------------------------------------------------------------------+
// | Copyrights Armia Systems ? 2010                                      |
// | All rights reserved                                                  |
// +------------------------------------------------------

class ControllerLocationdetails extends BaseController {
    public function init() {

        parent::init();

        $this->_common	 = new ModelCommon();
        $this->_session         = new LibSession();


        if(PageContext::$response->settings['GoogleMap']=='Y')
        {
            //PageContext::addScript("http://maps.googleapis.com/maps/api/js?key=AIzaSyDZ0qMJNqSxi8QJFuUDuPdE7Pwh3TPCjpo&sensor=true");

            $googleMapKey = Apputils::fetchSettings('GoogleMapValue');
            PageContext::addScript("http://maps.googleapis.com/maps/api/js?key=".$googleMapKey."&sensor=true");

        }
        PageContext::addScript("modal.popup.js");

        PageContext::addScript('locationdetails.js');
        PageContext::addScript('tooltip.js');
        PageContext::addJsVar("BASE_URL", BASE_URL);

        PageContext::addJsVar('calendarDisplayOnly', 1);


        PageContext::addStyle('details.css',true);
        PageContext::addStyle('tabbed-content.css',true);
        PageContext::addStyle('popup.css',true);
        PageContext::addStyle("jquery-ui-1.8.23.custom.css",true);

        // Meta Data
        Utils::getMetaContents('location');
        
        Apputils::fetchSettings("operation_mode");

        PageContext::$response->facebbokId = Apputils::fetchSettings('fb_app_id');
        if(PageContext::$response->settings['social_share_enable']=='Y')
            PageContext::registerPostAction("sharemenu", "sharemenu","locationdetails","default");

        PageContext::registerPostAction("center-main", "index","locationdetails","default");
        PageContext::registerPostAction("center-right", "bookingpanel","locationdetails","default");
        if(PageContext::$response->settings['GoogleMap']=='Y')
            PageContext::registerPostAction("center-right", "locationmap","locationdetails","default");
        PageContext::addPostAction("popup","index");



        if(PageContext::$response->operation_mode!=1)  //1 for single destination single location
            PageContext::registerPostAction("center-right", "similarlistings","locationdetails","default");

        PageContext::$body_class= 'details';
    }


 public function index($locationId,$locationType='')
 {
    $db                     = new Db();
    if((is_numeric($locationId) && is_numeric($locationType)) ||  $locationType=='expedia') {
        
    }
    else {
        $getlocation            = $db->selectResult('locations','nLocation_Id'," location_alias='$locationId'");
        $locationId             = $getlocation[0]->nLocation_Id;

        $getlocation            = $db->selectResult('special_offers','nSp_Id'," vAlias='$locationType'");
        $locationType           = $getlocation[0]->nSp_Id;
    }


   if(trim($locationId) == '')
   {
     $this->redirect('error');
     exit();
   }
    

// check for the api location
 		 
 if($locationType == 'expedia')
 {
    PageContext::addJsVar("JQ_locationtype", 'expedia');
    PageContext::addJsVar("JQ_location_id", $locationId);
 			
    $searchParams = array();

    $searchParams['hotelId'] = $locationId;
    $hotelInfo = Apisearch::expediaHotelInfo($searchParams);
    PageContext::$response->locationType              	= 'expedia';
    PageContext::$response->destinationId              	= $hotelInfo->destinationId;
    PageContext::$response->locationDescription        	= $hotelInfo->locationDescription;
    PageContext::$response->locationName               	= $hotelInfo->locationName;
    PageContext::$response->locationAddress            	= $hotelInfo->locationAddress;
    PageContext::$response->locationStartingPrice      	= $hotelInfo->locationStartingPrice;
    PageContext::$response->locationAmenities          	= $hotelInfo->locationAmenities;
    PageContext::$response->locationGallery            	= $hotelInfo->locationGallery;
    		
    PageContext::addJsVar("JQ_starting_price", PageContext::$response->locationStartingPrice);


    $maximumNumberOfImagesToDisplay                         = Utils::getSettingsData('max_num_img'); 
    array_splice(PageContext::$response->locationGallery, $maximumNumberOfImagesToDisplay);
                
    if(sizeof(PageContext::$response->locationGallery) > 0)
      	PageContext::$response->defaultGalleryImage 	= PageContext::$response->locationGallery[0]['image'];

    PageContext::$response->locationRaings             	= ceil($hotelInfo->locationRaings);
    PageContext::$response->locationReviewsCount	= 0;
    PageContext::$response->roomTypes             	= $hotelInfo->roomTypes;
    $objSearchParams                                   	= $this->_session->get('SearchObject');
    		  
    		  
    $searchParams['arrivalDate'] 	= $objSearchParams->SearchStartDate;
    $searchParams['departureDate'] 	= $objSearchParams->SearchEndDate;
    $searchParams['room1'] 			= $objSearchParams->NumberOfRooms;		  
    PageContext::$response->roomInfo= Apisearch::getExpediaRoomInfo($searchParams); 	 
    $arrRoom 	=	explode('&', PageContext::$response->roomInfo);
    if(sizeof($arrRoom) > 0)
    {
    	$expActiveRoom = explode('=', $arrRoom[2]);
    	PageContext::$response->defaultAccomadationType = $expActiveRoom[1];
    			
    	$expActiveRoomPrice = explode('=', $arrRoom[4]);
    	PageContext::$response->locationStartingPrice = $expActiveRoomPrice[1]*$searchParams['room1'];;	 
    }


    PageContext::addJsVar("JQcenterLatitude", $hotelInfo->latitude);
    PageContext::addJsVar("JQcenterLongtitude", $hotelInfo->longitude);
    PageContext::addJsVar("JQ_total_gallery_images", count( PageContext::$response->locationGallery));
    PageContext::addJsVar("JQcenterLocationName", rawurlencode(PageContext::$response->locationName));
    PageContext::addJsVar("JQcenterLocationDescription", '');
    PageContext::addJsVar("JQcenterLocationImageSrc", rawurlencode(BASE_URL.'project/themes/default/images/sim001-thumb.jpg'));


 }
 else   // If location details are coming from db.
 {
    global $imageConfig;
 		
    PageContext::addJsVar("JQ_locationtype", 'db');
    PageContext::addJsVar("JQ_location_id", $locationId);
	
	        
    $customerDetails                                   	= json_decode($this->_session->get('customer'));
    $objSearchParams                                   	= $this->_session->get('SearchObject');
	
    PageContext::$response->searchedDestination        	= $objSearchParams->searchDestination;
	
    $details                                           	= Location::getLocationDetails($locationId);
    $roomDetails                                       	= Location::getLocationRoomInfo($locationId);
    $galleyDetails                                     	= Location::getLocationImages($locationId);
    $tempLocationReviews                               	= Location::getLocationReviews($locationId,'','R.nRatingId DESC',20);
    $tempLocationRatings                               	= Location::getAverageRating($locationId,'location');
	        
	
    if($customerDetails->nCust_Id>0)
    {
	$tempRatingStatus                               = Customer::hasRated($locationId,'location',$customerDetails->nCust_Id);
	PageContext::$response->customerRatingDetails   = $tempRatingStatus;
    }
	
	
	
    PageContext::$response->locationId                 = $locationId;
    PageContext::$response->locationDetails            = $details;

    if($details->nLocation_Id == '')
    {
        $this->redirect('error');
        exit();
    }
	
    $tempLocationDescription                           = stripslashes(htmlentities(trim($details->vLocation_Description)));
    $tempLocationName                                  = stripslashes(htmlentities(trim($details->vLocation_Name)));
    $tempLocationAddress                               = stripslashes(htmlentities(trim($details->vAddress)));
    $tempLocationAmenities                             = stripslashes(trim($details->vAmenities));
	
	
    PageContext::$response->destinationId              = $details->nDestination_Id;
    PageContext::$response->locationDescription        = ($tempLocationDescription=='') ? 'No description available !!!' : $tempLocationDescription;
    PageContext::$response->locationName               = ($tempLocationName=='') ? 'Unnamed location' : $tempLocationName;
    PageContext::$response->locationAddress            = ($tempLocationAddress=='') ? 'Unknown address' : $tempLocationAddress;
    PageContext::$response->locationStartingPrice      = ($details->nStartingPrice>0) ? $details->nStartingPrice : '0.00';
    PageContext::$response->locationAmenities          = $tempLocationAmenities;
    PageContext::$response->locationGallery            = $galleyDetails;
	
    PageContext::addJsVar("JQ_total_gallery_images", count($galleyDetails));
    PageContext::addJsVar("JQ_starting_price", PageContext::$response->locationStartingPrice);
	
	
	
    PageContext::$response->locationReviews            = $tempLocationReviews;
	        PageContext::$response->locationRaings             = $tempLocationRatings;
	        PageContext::$response->locationReviewsCount       = count(PageContext::$response->locationReviews);
	
	
	
	        PageContext::addJsVar("JQcenterLatitude", $details->vLatitude);
	        PageContext::addJsVar("JQcenterLongtitude", $details->vLongtitude);
	
	
	
	        if(strlen($tempLocationName)>=28)
	            $tempLocationName = stripslashes(htmlentities((substr($tempLocationName, 0, 25).'...')));
	        else
	            $tempLocationName = stripslashes(htmlentities($tempLocationName));
	
	
	
	
	        if(strlen($tempLocationDescription)>=88)
	            $tempLocationDescription = trim(stripslashes(strip_tags(substr($tempLocationDescription, 0, 88).'...')));
	        else
	            $tempLocationDescription = trim(stripslashes(strip_tags($tempLocationDescription)));
	
	
	        $tempAddressString  = $details->vAddress.','.$details->vCity.'&nbsp;'.$details->vState.'&nbsp;'.$details->vZip.','.$details->vCountry;
	
	
	        PageContext::addJsVar("JQcenterLocationName", rawurlencode($tempLocationName));
	        PageContext::addJsVar("JQcenterLocationDescription", rawurlencode($tempAddressString));
	        PageContext::addJsVar("JQcenterLocationImageSrc", rawurlencode(BASE_URL.'project/themes/default/images/sim001-thumb.jpg'));
	
	
	        PageContext::addJsVar('JQcenterLocationToolTip',BASE_URL."project/styles/images/blue_1.png");
	        PageContext::addJsVar('JQdefaultLocationToolTip',BASE_URL."project/styles/images/green_1.png");
	        PageContext::addJsVar('JQdefaultLocationToolTip_Active',BASE_URL."project/styles/images/red_1.png");
	
	
	
	        foreach(PageContext::$response->locationGallery as $tempKey => $tempValue) {
	
	            PageContext::$response->defaultGalleryImage        =	 BASE_URL . 'project/files/'. $imageConfig['location']['directory'] . '/' .  $imageConfig['location']['prefix']. $tempValue->file_path;
	            PageContext::$response->defaultGalleryImagetTitle        =$tempValue->vTitle	 ;
	            break;
	
	        }

 }


 		PageContext::addPostAction('similarlistings');



	    PageContext::addPostAction('bookingpanel');

	   	if(PageContext::$response->settings['GoogleMap']=='Y')
        	Apputils::loadGoogleMapConfigurations();

	    PageContext::addPostAction('calendar','calendar','calendar');
 		PageContext::$metaTitle = SITENAME .PageContext::$response->locationName;
 		
 		if($locationType == 'expedia')
 			PageContext::$response->pageurl = BASE_URL.'location/expedia';//$type = '/expedia'; 
                else
                    PageContext::$response->pageurl = BASE_URL.'location/'.$locationId.'/'.$locationType;
 		//PageContext::$response->pageurl = BASE_URL.'location/'.$locationId.$type;
 		
 		
    }


    /* Post Action */
    public function bookingpanel($locationId='',$offerId=''){ 
 
    	 	
        $objSearchParams           = $this->_session->get('SearchObject');     
        
        // external API location hotel details
        if(PageContext::$response->locationType == 'expedia')
        	$rateCodes = PageContext::$response->roomTypes;
        else
        	$rateCodes = Location::getLocationRatecodes(PageContext::$response->locationId,$limit=NULL);
        	
        $searchDetails    = json_decode($this->_session->get('SearchObject'));

        PageContext::$response->locationDefaultBookingPrice = 0.00;
        if(count($rateCodes)==0) {
            PageContext::$response->rateCodesDropdownProperties = 'disabled';
        }
        PageContext::$response->rateCodes = $rateCodes;
        foreach($rateCodes as $tempKey => $tempValue){
            $defaultAccomadationType = $tempValue->nAt_Id;
            break;
        }
        
    	if(PageContext::$response->locationType == 'expedia')	// expedia default room info
        	$defaultAccomadationType = PageContext::$response->defaultAccomadationType;
        
        
        if(PageContext::$request['selectedAccomodationTypes'] == '')
        PageContext::$response->defaultAccomadationType = $defaultAccomadationType;
        else
        $defaultAccomadationType = PageContext::$response->defaultAccomadationType = PageContext::$request['selectedAccomodationTypes'];

        // Get Group Discount Data
        $availableAccoTypeId = Location::getAvailableAccomodationTypeId($locationId,PageContext::$response->defaultAccomadationType);
        
        $groupDiscountData = Location::getGroupDiscountDetailsByAccomodationType($availableAccoTypeId->nAat_Id);
        if(count($groupDiscountData) > 0){
            PageContext::$response->gdContent = $this->getAvailableOfferTootlTipContent($groupDiscountData);
        }
        //echopre(PageContext::$response->gdContent);
        // Get Group Discount Data
        
        if($offerId > 0) $offerData  = Location::getSpecialOfferDetailsByOfferId($offerId); 
        //echopre($offerData);
        if(!empty($offerData)){
            PageContext::$response->selectedFromDate  = Utils::dateFormat($offerData->dStartDate,'Y-m-d','m/d/Y');
            $formatedFromDate                         = Utils::dateFormat($offerData->dStartDate,'Y-m-d','m-d-Y'); 
        }else if($objSearchParams->SearchStartDate!=''){
            PageContext::$response->selectedFromDate = $objSearchParams->SearchStartDate;
            $formatedFromDate                        = Utils::dateFormat($objSearchParams->SearchStartDate,'m/d/y','m-d-Y');
        }else{
            PageContext::$response->selectedFromDate = date('m/d/Y');
            $formatedFromDate                        = date('m-d-Y');
        }

        if(!empty($offerData)){
            PageContext::$response->selectedToDate  = date('m/d/Y',strtotime($offerData->dStartDate. "+1 day"));
            $formatedToDate                         = date('m-d-Y',strtotime($offerData->dStartDate. "+1 day"));
        }else if($objSearchParams->SearchEndDate!=''){
            PageContext::$response->selectedToDate   = $objSearchParams->SearchEndDate;
            $formatedToDate                          =  Utils::dateFormat($objSearchParams->SearchEndDate,'m/d/y','m-d-Y');
        }else{
            PageContext::$response->selectedToDate   = date('m/d/Y',strtotime('+1 day'));
            $formatedToDate                          = date('m-d-Y',strtotime('+1 day')); 
        }

        if($objSearchParams->GuestCount>0){
            PageContext::$response->defaultNumberOfGuests = $objSearchParams->GuestCount;
        }else{
            PageContext::$response->defaultNumberOfGuests = 1;
        }


        if($objSearchParams->GuestChildrenCount>-1){
            PageContext::$response->defaultNumberOfChildren = $objSearchParams->GuestChildrenCount;
        }
        else{
            PageContext::$response->defaultNumberOfChildren = 1;
        }
        
        if($objSearchParams->NumberOfRooms>0){
            PageContext::$response->numberOfRooms = $objSearchParams->NumberOfRooms;
            $numberOfRooms                        = $objSearchParams->NumberOfRooms;
        }
        else{
            PageContext::$response->numberOfRooms = 1;
            $numberOfRooms                        = 1;
        }
 		// external API location hotel details
        if(PageContext::$response->locationType == 'expedia')
        	$defaultBookingPrice	= PageContext::$response->locationStartingPrice;
        else
      		$defaultBookingPrice = Booking::getExtraAmount(PageContext::$response->locationId,$defaultAccomadationType,PageContext::$response->defaultNumberOfGuests,$formatedFromDate,$formatedToDate,PageContext::$response->locationStartingPrice,$numberOfRooms);

        if(strstr($defaultBookingPrice,'blocked-'))
        {
            $tempArray = explode('blocked-',$defaultBookingPrice);
            
            if($tempArray[1] != '')
            {
               PageContext::$response->blockedMessage = $tempArray[1];
            }
        }
            //echo $defaultBookingPrice;die;
            $defaultBookingPrice = ($defaultBookingPrice>0) ? $defaultBookingPrice : 0;
            PageContext::$response->locationDefaultBookingPrice   = $defaultBookingPrice;

    }

/* Post Action */
 public function similarlistings()
 {

   $similarLocationDetails                           = Location::getSimilarLocations(PageContext::$response->destinationId,'L.nLocation_Id!="'.PageContext::$response->locationId.'"','L.vFeatured DESC,L.vLocation_Name ASC',5);
   PageContext::$response->similarLocationDetails    = $similarLocationDetails;
   $tempCounter                                      = 0;



   

   if(PageContext::$response->operation_mode != 1)
   {

     foreach(PageContext::$response->similarLocationDetails as $tempKey => $tempVal)
     {

        $galleyDetails                    = Location::getLocationImages($tempVal->nLocation_Id);
        $tempFirstValue                   = reset($galleyDetails);
        $tempFirstKey                     = key($galleyDetails);

        PageContext::$response->similarLocationDetails[$tempKey]->locationGallery   = $galleyDetails[$tempFirstKey];

        if(strlen($tempVal->vLocation_Name)>=28)
           $tempLocationName = stripslashes(htmlentities((substr($tempVal->vLocation_Name, 0, 25).'...')));

        else
           $tempLocationName = stripslashes(htmlentities($tempVal->vLocation_Name));


        if(strlen($tempVal->vLocation_Description) >= 88)
           $tempLocationDescription = stripslashes(strip_tags(substr($tempVal->vLocation_Description, 0, 88).'...'));

        else
           $tempLocationDescription = stripslashes(strip_tags($tempVal->vLocation_Description));


           $tempAddressString  = $tempVal->vAddress.','.$tempVal->vCity.'&nbsp;'.$tempVal->vState.'&nbsp;'.$tempVal->vZip.','.$tempVal->vCountry;


            PageContext::addJsVar("JQ_additional_mark_latitide_".$tempCounter, $tempVal->vLatitude);
            PageContext::addJsVar("JQ_additional_mark_longtitide_".$tempCounter, $tempVal->vLongtitude);
            PageContext::addJsVar("JQ_additional_mark_locationName_".$tempCounter, rawurlencode($tempLocationName));
            PageContext::addJsVar("JQ_additional_mark_locationDescription_".$tempCounter, rawurlencode($tempAddressString));
            PageContext::addJsVar("JQ_additional_mark_locationImageSrc_".$tempCounter, rawurlencode(BASE_URL.'project/themes/default/images/sim001-thumb.jpg'));
            PageContext::addJsVar("JQ_additional_mark_locationUrl_".$tempCounter, rawurlencode(BASE_URL.'location/'.$tempVal->nLocation_Id));

            $tempCounter++;

     }

  }




        
         



        PageContext::addJsVar("JQ_SimilarLocationCounter", $tempCounter);


    }

    /* Post Action */
    public function locationmap() {


    }
    /* Post Action */
    public function sharemenu() {

    }


    public function ajaxGetAvailableOfferData($accomadationType,$locationId) {

        PageContext::$full_layout_rendering = false;
        $this->view->disableLayout();
        
        // Get Group Discount Data
        $availableAccoTypeId = Location::getAvailableAccomodationTypeId($locationId,$accomadationType);
        $groupDiscountData  = Location::getGroupDiscountDetailsByAccomodationType($availableAccoTypeId->nAat_Id);
         
        if(count($groupDiscountData) > 0){
            $gdContent = $this->getAvailableOfferTootlTipContent($groupDiscountData); 
        }
        echo $gdContent ;
        // Get Group Discount Data
        exit(); 
    }

    public function getAvailableOfferTootlTipContent($groupDiscountDataArray){ 

        /*
        $str = '<div style="font-size: 13px; color: #999; padding: 8px 0 0 9px; cursor: pointer;">
                    <a class="tip_trigger">'.BOOKING_AVAILABLE_OFFER_TITLE.'
                        <div class="tip">'.BOOKING_AVAILABLE_OFFER_MSG_PART1.' :  <br/> <br/>';
                            foreach($groupDiscountDataArray as $groupDiscountData){
                                $str .= $groupDiscountData->group_size.' '.BOOKING_AVAILABLE_OFFER_MSG_PART2.' '.$groupDiscountData->group_size_range.' '.BOOKING_AVAILABLE_OFFER_MSG_PART3.' - '. $groupDiscountData->discount_percentage.'% '.BOOKING_AVAILABLE_OFFER_MSG_PART4.' <br/>';
                             }
                        $str .='</div>
                    </a>
                </div>';
                */

             $str = '<div class="tip">'.BOOKING_AVAILABLE_OFFER_MSG_PART1.' :  <br/> <br/>';
                            foreach($groupDiscountDataArray as $groupDiscountData){
                                $str .= $groupDiscountData->group_size.' '.BOOKING_AVAILABLE_OFFER_MSG_PART2.' '.$groupDiscountData->group_size_range.' '.BOOKING_AVAILABLE_OFFER_MSG_PART3.' - '. $groupDiscountData->discount_percentage.'% '.BOOKING_AVAILABLE_OFFER_MSG_PART4.' <br/>';
                             }
                        $str .='</div>
                    ';

        return $str;
            
    }

    /*ajax function
     *
     */


}

?>
