TRUNCATE TABLE `cms_sections`;
INSERT IGNORE INTO `cms_sections` (`id`, `group_id`, `section_name`, `section_alias`, `table_name`, `section_config`, `visibilty`, `display_order`, `user_privilege`) VALUES
	(1, 3, 'Manage Groups', 'groups', 'cms_groups', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"publishColumn":"published",\r\n"listColumns":["id","group_name","user_privilege"],\r\n"showColumns":["id","group_name","position","user_privilege"],\r\n"detailColumns":["id","group_name","position","user_privilege"],\r\n"detailHeaderColumns":["group_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","searchable":"searchable","editoptions":{"type":"hidden"}},\r\n    "group_name":{"name":"Group Name","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Group Name","class":"textbox"}},\r\n    "position":{"name":"Display Order","sortable":"true","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}},\r\n    "user_privilege":{"name":"Privilege","sortable":"true","searchable":"searchable","editoptions":{"type":"select","source":{"all":"All","s":"Superadmin"},"source_type":"array","label":"Privilege","class":"select","enumvalues":{"all":"All","s":"Superadmin"}}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 2, 'dev'),
	(2, 3, 'Manage Sections', 'sections', 'cms_sections', '{\r\n"keyColumn":"id",\r\n"orderBy":{"id":"ASC"},\r\n"listColumns":["group_id","section_name","section_alias","visibilty","display_order"],\r\n"showColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailColumns":["id","group_id","section_name","section_alias","table_name","section_config","visibilty","display_order"],\r\n"detailHeaderColumns":["section_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "group_id":{"name":"Group ID","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"select","source":"Cms::getAllGroups","source_type":"function","label":"Group Name","class":"select"},"external":"true","externalOptions":{"externalTable":"cms_groups","externalColumn":"id","externalShowColumn":"group_name"}},\r\n    "section_name":{"name":"Section Name","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Name","class":"textbox"}},\r\n    "section_alias":{"name":"Section Alias","sortable":"true","searchable":"searchable","editoptions":{"validations":["required"],"type":"textbox","label":"Section Alias","class":"textbox"}},\r\n    "table_name":{"name":"Table Name","editoptions":{"validations":["required"],"type":"textbox","label":"Table Name","class":"textbox"}},\r\n    "section_config":{"name":"Section Config","editoptions":{"validations":["required"],"type":"textarea","label":"Section Config","class":"textarea"}},\r\n    "visibilty":{"name":"Make Visible","sortable":"true","searchable":"searchable","editoptions":{"type":"checkbox","label":"Make Visible","class":"inline","default":"yes","enumvalues":{"1":"Visible","0":"Invisible"}}},\r\n    "display_order":{"name":"Display Order","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Display Order","class":"textbox"}}\r\n    },\r\n"opertations":["add","edit","delete","view","publish"]\r\n}', '1', 3, 'dev'),
	(3, 3, 'Manage Settings', 'manage_settings', 'tbl_cms_settings', '{\r\n"keyColumn":"id",\r\n"listColumns":["cms_set_name","cms_set_value"],\r\n"showColumns":["cms_set_name","cms_set_value"],\r\n"detailColumns":["id","cms_set_name","cms_set_value"],\r\n"detailHeaderColumns":["cms_set_name"],\r\n"columns":{\r\n    "id":{"name":"ID","sortable":"true","editoptions":{"type":"hidden"}},\r\n    "cms_set_name":{"name":"Name","sortable":"true","searchable":"searchable","editoptions":{"type":"disabled","label":"Name"}},\r\n    "cms_set_value":{"name":"Value","sortable":"true","searchable":"searchable","editoptions":{"type":"textbox","label":"Value","class":"textbox"}}\r\n},\r\n"opertations":["edit","view"]\r\n}', '1', 1, 'dev'),
	(4, 4, 'Settings', 'settings', 'tbl_lookup', '{"customAction":"true","controller":"cmshelper","method":"settingsdisplay","module":"default"}\r\n', '1', 1, 'all'),
	(5, 4, 'Destinations', 'destination', 'tbl_destination', '{\r\n    "keyColumn": "nDestination_Id",\r\n"breadCrumbColumn":"vDestination_Name",\r\n     "detailHeaderColumnPrefix": "Destination: ",\r\n    "detailHeaderColumns": [\r\n        "vDestination_Name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nDestination_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "vDestination_Name",\r\n        "tDestination_Description",\r\n        "file_id",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "nDestination_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Destination",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlDestinationLink"\r\n            }\r\n        },\r\n        "tDestination_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nDestination_Price": {\r\n            "name": "Starting Price",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting price for flash header",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Current Image",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Current Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n  "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n"listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeDestinationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "destination_location_tag": {\r\n            "name": "Locations",\r\n            "section": "destination_location_tag",\r\n            "child_table": "tbl_locations",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        },\r\n        "destination_package_tag": {\r\n            "name": "Packages",\r\n            "section": "destination_package_tag",\r\n            "child_table": "tbl_packages",\r\n            "parent_join_column": "nDestination_Id",\r\n            "child_join_column": "nDestination_Id"\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationImagefiles","afterEditRecord":"Cmshelper::moveDestinationImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "customdelete",\r\n        "add"\r\n    ],\r\n"customDeleteOperation":"Cmshelper::deleteDestination"\r\n}', '1', 4, 'all'),
	(6, 4, 'Locations', 'location', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n    "includeJsFiles": [\r\n        "cms_location.js"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nLocation_Id": "DESC"\r\n    },\r\n    "breadCrumbColumn": "vLocation_Name",\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "nDestination_Id",\r\n        "vFeatured",\r\n        "vActive",\r\n        "Promote"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities",\r\n        "Promote"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n        "vZip",\r\n        "nStartingPrice",\r\n        "vFeatured",\r\n        "vActive",\r\n        "vAmenities"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllDestinations",\r\n                "source_type": "function",\r\n                "label": "Destination",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            },\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getDestinationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea",\r\n                "editorType": "ckeditor"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "StartingPrice ($)",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "StartingPrice ($)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "Not Featured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        },\r\n        "Promote": {\r\n            "name": "Publish",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::displayPromoteLink"\r\n        }\r\n    },\r\n    "relations": {\r\n        "location_offer_tag": {\r\n            "name": "SpecialOffers",\r\n            "section": "location_offer_tag",\r\n            "child_table": "tbl_special_offers",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_gallery_tag": {\r\n            "name": "Gallery",\r\n            "section": "location_gallery_tag",\r\n            "child_table": "tbl_gallery",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_accomodation_tag1": {\r\n            "name": "Accommodations",\r\n            "section": "location_accomodation_tag1",\r\n            "child_table": "tbl_available_acco_type",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        },\r\n        "location_review_tag": {\r\n            "name": "Reviews",\r\n            "section": "location_review_tag",\r\n            "child_table": "tbl_rating",\r\n            "parent_join_column": "nLocation_Id",\r\n            "child_join_column": "nLocation_Id"\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::mapLatLong",\r\n        "afterEditRecord": "Cmshelper::mapLatLong"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 5, 'all'),
	(9, 6, 'Help Category', 'help_category', 'tbl_HelpCategory', '{\r\n    "keyColumn": "hcid",\r\n"detailHeaderColumns":["hcid"],\r\n    "orderBy": {\r\n        "hcid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hcid",\r\n        "htype",\r\n        "hctitle",\r\n        "hcposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hcid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n               \r\n            }\r\n        },\r\n        "htype": {\r\n            "name": "User Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "source_type": "array",\r\n                "label": "User Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "admin": "Admin",\r\n                    "client": "Client"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hctitle": {\r\n            "name": "Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hcposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
	(7, 6, 'Static Content', 'static_content', 'tbl_content', '{\r\n    "keyColumn": "nContent_Id",\r\n    "detailHeaderColumns": [\r\n        "display_title"\r\n    ],\r\n    "orderBy": {\r\n        "nContent_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "showColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "detailColumns": [\r\n        "nContent_Id",\r\n        "vLocation",\r\n        "vContent"\r\n    ],\r\n    "columns": {\r\n        "nContent_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vContent": {\r\n            "name": "Content",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "htmlEditor",\r\n                "label": "Content",\r\n                "class": "textarea"\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "edit",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
	(8, 1, 'Inquiries', 'enquiries', 'tbl_enquiry', '{\r\n    "keyColumn": "nEnq_Id",\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "detailHeaderColumns": [\r\n        "nEnq_Id"\r\n    ],\r\n    "listColumns": [\r\n        "vName",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "showColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n"status",\r\n        "dPasted_Date"\r\n    ],\r\n    "detailColumns": [\r\n        "nEnq_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "dPasted_Date",\r\n        "tComments",\r\n"status"\r\n    ],\r\n    "columns": {\r\n        "nEnq_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n"status" :{\r\n"name" :"Status",\r\n"customColumn": "true",\r\n                "customaction": "Cmshelper::getInquiryReplyPopupUrl"\r\n},\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInquiryUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n            "searchable": "searchable"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "tComments": {\r\n            "name": "Inquiry"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "delete"\r\n    ]\r\n}', '1', 4, 'all'),
	(10, 6, 'Help Content', 'help_content', 'tbl_Help', '{\r\n    "keyColumn": "hid",\r\n"detailHeaderColumns":[ "hid"],\r\n    "orderBy": {\r\n        "hid": "ASC"\r\n    },\r\n    "listColumns": [\r\n     \r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n         "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "detailColumns": [\r\n        "hid",\r\n        "hcid",\r\n        "htitle",\r\n        "hdescription",\r\n        "hposition",\r\n        "active"\r\n    ],\r\n    "columns": {\r\n        "hid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n                \r\n            }\r\n        },"hcid": {\r\n           "name": "Category",\r\n           "sortable": "true",\r\n           "searchable": "true",\r\n           "editoptions": {\r\n               "validations": [\r\n                   "required"\r\n               ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllHelpCategories",\r\n                "source_type": "function",\r\n                "label": "Category",\r\n                "class": "select"\r\n           },\r\n           "external": "true",\r\n           "externalOptions": {\r\n               "externalTable": "tbl_HelpCategory",\r\n               "externalColumn": "hcid",\r\n               "externalShowColumn": "hctitle"\r\n           }\r\n       },\r\n        "htitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                \r\n                \r\n                "label": "Title",\r\n                "class": "textbox",\r\n                \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hdescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "hposition": {\r\n            "name": "Sort Order",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Sort Order",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 12, 'all'),
	(11, 1, 'Locations', 'destination_location_tag', 'tbl_locations', '{\r\n    "keyColumn": "nLocation_Id",\r\n "includeJsFiles": [\r\n        "cms_location.js"\r\n    ],\r\n    "detailHeaderColumnPrefix": "Location: ",\r\n    "detailHeaderColumns": [\r\n        "vLocation_Name"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nDestination_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAddress",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "showColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n "vZip",\r\n          "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "detailColumns": [\r\n        "nLocation_Id",\r\n        "nDestination_Id",\r\n        "vLocation_Name",\r\n        "vLocation_Description",\r\n        "vAmenities",\r\n        "vAddress",\r\n        "vCity",\r\n        "vCountry",\r\n        "vState",\r\n       "vZip",\r\n       "nStartingPrice",\r\n        "vActive",\r\n        "vFeatured"\r\n    ],\r\n    "columns": {\r\n        "nLocation_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Location",\r\n                "class": "textbox"\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getLocationPopupUrlLocationLink"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "vLocation_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAmenities": {\r\n            "name": "Amenities",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Amenities",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vAddress": {\r\n            "name": "Address",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textarea",\r\n                "label": "Address",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "vCity": {\r\n            "name": "City",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "City",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vState": {\r\n            "name": "State",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllStates",\r\n                "source_type": "function",\r\n                "label": "State",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "vZip": {\r\n            "name": "Zip",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Zip",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vCountry": {\r\n            "name": "Country",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllCountries",\r\n                "source_type": "function",\r\n                "label": "Country",\r\n                "class": "select"\r\n            }\r\n        },\r\n        "nStartingPrice": {\r\n            "name": "Starting Price",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Starting Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Is Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeLocationFeaturedStatus",\r\n                "enumvalues": {\r\n                    "Yes": "Featured",\r\n                    "No": "Non featured"\r\n                },\r\n                "buttonColors": {\r\n                    "Yes": "green",\r\n                    "No": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(12, 1, 'Feedback', 'feedback', 'tbl_feedbacks', '{\r\n    "keyColumn": "nFeedback_Id",\r\n     "detailHeaderColumnPrefix": "Feedback: ",\r\n\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "orderBy": {\r\n        "dPasted_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "showColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "detailColumns": [\r\n        "nFeedback_Id",\r\n        "vName",\r\n        "vEmail",\r\n        "vPhone",\r\n        "vAddress",\r\n        "vDestination",\r\n        "dPasted_Date",\r\n        "tComments"\r\n    ],\r\n    "columns": {\r\n        "nFeedback_Id": {\r\n            "name": "ID",\r\n            "sortable": "true"\r\n        },\r\n        "vName": {\r\n            "name": "Customer",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getFeedbackUserPopupUrl"\r\n            }\r\n        },\r\n        "vPhone": {\r\n            "name": "Phone"\r\n        },\r\n        "vEmail": {\r\n            "name": "Email",\r\n  "searchable": "true"\r\n        },\r\n        "vAddress": {\r\n            "name": "Address"\r\n        },\r\n        "vDestination": {\r\n            "name": "Destination",\r\n            "searchable": "true",\r\n            "sortable": "true",\r\n             "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        },\r\n        "tComments": {\r\n            "name": "Feedback"\r\n        },\r\n        "dPasted_Date": {\r\n            "name": "Posted Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "delete",\r\n        "view"\r\n    ]\r\n}', '1', 4, 'all'),
	(15, 4, 'Accommodation Types', 'accomodation_type', 'tbl_accomodation_types', '{\r\n    "keyColumn": "nAt_Id",\r\n     "detailHeaderColumnPrefix": "Accomodation Type: ",\r\n    "detailHeaderColumns": [\r\n        "vAt_Name"\r\n    ],\r\n    "orderBy": {\r\n        "nAt_Id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n          "nAt_Id",\r\n        "vAt_Name",\r\n        "vAt_Description",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAt_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Type",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Type",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getAccomodationPopupUrl"\r\n            }\r\n        },\r\n        "vAt_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAccomodationStatus",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "buttonColors": {\r\n                    "active": "green",\r\n                    "deactive": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 5, 'all'),
	(13, 4, 'Packages', 'destination_package_tag', 'tbl_packages', '{\r\n    "keyColumn": "nPackage_Id",\r\n"handleFile" : "true",\r\n   "detailHeaderColumnPrefix": "Package: ",\r\n    "detailHeaderColumns": [\r\n        "vPackage_Title"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nPackage_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nPackage_Id",\r\n"nDestination_Id",\r\n        "vPackage_Title",\r\n        "vPackage_Description",\r\n        "vSpecial_Offer",\r\n        "vPackage_photo_below_Description",\r\n        "nAmount",\r\n        "vFeatured",\r\n        "vPackage_Status",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nPackage_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n"nDestination_Id":{\r\n"external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "nDestination_Id"\r\n            }\r\n},\r\n        "vPackage_Title": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vSpecial_Offer": {\r\n            "name": "Offer",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Special Offer",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vPackage_Description": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Overview",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "vPackage_photo_below_Description": {\r\n            "name": "Description in details page ",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Description in details page",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Amount ($)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vPackage_Status": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeatured": {\r\n            "name": "Featured",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Featured",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "No": "No",\r\n                    "Yes": "Yes"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateAliasName",\r\n        "afterEditRecord": "Cmshelper::updateAliasName"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(14, 4, 'Special Offers', 'location_offer_tag', 'tbl_special_offers', '{\r\n    "keyColumn": "nSp_Id",\r\n"handleFile":"true",\r\n   "detailHeaderColumnPrefix": "Special Offer: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nSp_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nSp_Id",\r\n        "nLocation_Id",\r\n        "vTitle",\r\n        "tDescription",\r\n        "nRate",\r\n        "dStartDate",\r\n        "dEndDate",\r\n        "vActive",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nSp_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "tDescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "nRate": {\r\n            "name": "Discount Price (%)",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Discount Price (%)",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "dStartDate": {\r\n            "name": "Start Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "dEndDate": {\r\n            "name": "End Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "m/d/Y"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 200 x 130. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateOfferAliasName",\r\n        "afterEditRecord": "Cmshelper::updateOfferAliasName"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(16, 1, 'Customers', 'customers', 'tbl_customers', '{\n    "keyColumn": "nCust_Id",\n    "includeJsFiles": [\n        "cms_location.js"\n    ],\n    "detailHeaderColumnPrefix": "Customer: ",\n    "detailHeaderColumns": [\n        "vFirstname"\n    ],\n    "orderBy": {\n        "nCust_Id": "ASC"\n    },\n    "listColumns": [\n        "vFirstname",\n        "vEmail",\n        "dDatejoin",\n        "vActive"\n    ],\n    "showColumns": [\n        "nCust_Id",\n        "vLogin",\n        "vPassword",\n        "vFirstname",\n        "vLastname",\n        "vEmail",\n        "vAddress1",\n        "vCity",\n        "vCountry",\n        "vState",\n        "vZip",\n        "vTelephone",\n        "dDatejoin",\n        "vActive"\n    ],\n    "detailColumns": [\n        "nCust_Id",\n        "vLogin",\n        "vPassword",\n        "vFirstname",\n        "vLastname",\n        "vEmail",\n        "vAddress1",\n        "vCity",\n        "vCountry",\n        "vState",\n        "vZip",\n        "vTelephone",\n        "dDatejoin",\n        "vActive"\n    ],\n    "columns": {\n        "nCust_Id": {\n            "name": "ID",\n            "sortable": "true",\n            "editoptions": {\n                "type": "hidden"\n            }\n        },\n        "vLogin": {\n            "name": "Login Name",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Login Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vPassword": {\n            "name": "Password",\n            "editoptions": {\n                "type": "password",\n                "label": "Password",\n                "class": "textbox"\n            }\n        },\n        "vFirstname": {\n            "name": "First Name",\n            "searchable": "true",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "First Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vLastname": {\n            "name": "Last Name",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Last Name",\n                "class": "textbox",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vEmail": {\n            "name": "Email",\n            "sortable": "true",\n            "searchable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Email",\n                "class": "textbox",\n                "validations": [\n                    "required","email"\n                ]\n            }\n        },\n        "vAddress1": {\n            "name": "Address",\n            "editoptions": {\n                "type": "textarea",\n                "label": "Address",\n                "class": "textarea",\n                "validations": [\n                    "required"\n                ]\n            }\n        },\n        "vCity": {\n            "name": "City",\n            "searchable": "true",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "textbox",\n                "label": "City",\n                "class": "textbox"\n            }\n        },\n        "vState": {\n            "name": "State",\n            "sortable": "true",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "select",\n                "source": "Cmshelper::getAllStates",\n                "source_type": "function",\n                "label": "State",\n                "class": "select"\n            },\n            "external": "true",\n            "externalOptions": {\n                "externalTable": "tbl_state",\n                "externalColumn": "ts_code",\n                "externalShowColumn": "ts_name"\n            }\n        },\n        "vZip": {\n            "name": "Zip",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Zip",\n                "class": "textbox"\n            }\n        },\n        "vCountry": {\n            "name": "Country",\n            "editoptions": {\n                "validations": [\n                    "required"\n                ],\n                "type": "select",\n                "source": "Cmshelper::getAllCountries",\n                "source_type": "function",\n                "label": "Country",\n                "class": "select"\n            },\n            "external": "true",\n            "externalOptions": {\n                "externalTable": "tbl_country",\n                "externalColumn": "tc_code",\n                "externalShowColumn": "tc_name"\n            }\n        },\n        "vTelephone": {\n            "name": "Telephone",\n            "sortable": "true",\n            "editoptions": {\n                "type": "textbox",\n                "label": "Telephone",\n                "class": "textbox"\n            }\n        },\n        "vActive": {\n            "name": "Status",\n            "searchable": "true",\n            "editoptions": {\n                "type": "select",\n                "source": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "source_type": "array",\n                "label": "Status",\n                "class": "select",\n                "enumvalues": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "validations": [\n                    "required"\n                ]\n            },\n            "listoptions": {\n                "type": "button",\n                "customaction": "Cmshelper::changeUserStatus",\n                "enumvalues": {\n                    "active": "Active",\n                    "inactive": "Inactive"\n                },\n                "buttonColors": {\n                    "active": "green",\n                    "inactive": "red"\n                }\n            }\n        },\n        "dDatejoin": {\n            "name": "Registered On",\n            "sortable": "true",\n            "dbFormat": "date",\n            "displayFormat": "m/d/Y"\n        }\n    },\n    "customActions": {\n        "afterAddRecord": "Customer::updateCustomerRegisterTime"\n    },\n    "customOperations": {\n        "login": {\n            "options": {\n                "target": "newtab",\n                "name": "Login",\n                "linkSource": "Cmshelper::getuserLoggedInUrl"\n            }\n        }\n    },\n    "opertations": [\n        "add",\n        "view",\n        "edit",\n        "customdelete"\n    ],\n    "customDeleteOperation": "Cmshelper::deleteCustomer"\n}', '1', 5, 'all'),
	(17, 1, 'Dashboard', 'dashboard', 'tbl_lookup', '{\r\n    "dashboardPanel": "true",\r\n    "listingPanel": "true",\r\n    "listinPanelRow": "2",\r\n    "listingPanel1": {\r\n        "columns": "2",\r\n        "column1": {\r\n            "title": "Inquiries",\r\n            "titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getInquiry",\r\n            "fetchValue": "Cmshelper::fetchRecentEnquiries",\r\n            "listcolumns": {\r\n                "vName": {\r\n                    "name": "Customer"\r\n                },\r\n                "vEmail": {\r\n                    "name": "Email"\r\n                },\r\n                "dPasted_Date": {\r\n                    "name": "Inquired On"\r\n                }\r\n            }\r\n        },\r\n        "column2": {\r\n            "title": "Recent Orders",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getOrders",\r\n            "fetchValue": "Cmshelper::fetchRecentOrders",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dBooking_Date": {\r\n                    "name": "Booked On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "listingPanel2": {\r\n        "columns": "1",\r\n        "column1": {\r\n            "title": "Cancellations",\r\n"titlelink": "View All",\r\n            "titlelinkSection": "Cmshelper::getCancelledOrders",\r\n            "fetchValue": "Cmshelper::getCancellations",\r\n            "listcolumns": {\r\n                "vFirstname": {\r\n                    "name": "Customer"\r\n                },\r\n                "nAmount": {\r\n                    "name": "Canceled Amount ($)"\r\n                },\r\n                "vStatus": {\r\n                    "name": "Status"\r\n                },\r\n                "dCancelDate": {\r\n                    "name": "Canceled On"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "graphPanel": "true",\r\n    "graphpanelRow": "1",\r\n    "graphPanel1": {\r\n        "columns": "2",\r\n        "graph1": {\r\n            "type": "MSColumn3D",\r\n            "caption": "Bookings",\r\n            "xAxisName": "",\r\n            "yAxisName": "BookingCount",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getBookingCount"\r\n                }\r\n            }\r\n        },\r\n        "graph2": {\r\n            "type": "MSLine",\r\n            "caption": "Accommodation Availability",\r\n            "xAxisName": "",\r\n            "yAxisName": "Available Room Count",\r\n            "width": "480",\r\n            "height": "300",\r\n            "dataSetsCount": "1",\r\n            "dataSets": {\r\n                "dataset1": {\r\n                    "name": "",\r\n                    "color": "#D3AC4F",\r\n                    "fetchValue": "Cmshelper::getAvailableRoomCount"\r\n                }\r\n            }\r\n        }\r\n    }\r\n}', '1', 1, 'all'),
	(18, 4, 'Destination Gallery', 'destination_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": " tbl_destination",\r\n        "referenceColumn": "nDestination_Id",\r\n        "referenceTableForiegnKey": "nDestination_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nDestination_Id",\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 120 x 112. Allowed file formats are GIF,JPG,PNG."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDestination_Id": {\r\n            "name": "Destination",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_destination",\r\n                "externalColumn": "nDestination_Id",\r\n                "externalShowColumn": "vDestination_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveDestinationGalleryImagefiles","afterEditRecord":"Cmshelper::moveDestinationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(19, 1, 'Gallery', 'location_gallery_tag', 'tbl_gallery', '{\r\n    "keyColumn": "nGallery_Id",\r\n    "handleFile": "true",\r\n    "detailHeaderColumnPrefix": "Gallery: ",\r\n    "detailHeaderColumns": [\r\n        "vTitle"\r\n    ],\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nGallery_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vTitle",\r\n        "file_id"\r\n    ],\r\n    "showColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "detailColumns": [\r\n        "nGallery_Id",\r\n        "vTitle",\r\n        "file_id",\r\n        "nLocation_Id"\r\n    ],\r\n    "columns": {\r\n        "nGallery_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vTitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Thumbnail Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal image size 915 x 405. Allowed file formats are GIF,JPG,PNG"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        }\r\n    },\r\n"customActions":{"afterAddRecord":"Cmshelper::moveLocationGalleryImagefiles","afterEditRecord":"Cmshelper::moveLocationGalleryImagefiles"},\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(20, 1, 'Orders', 'booking_orders', 'tbl_booking', '{\r\n    "keyColumn": "nBooking_Id",\r\n    "detailHeaderColumnPrefix": "Order: ",\r\n    "detailHeaderColumns": [\r\n        "OrderId"\r\n    ],\r\n    "dataSource": "external",\r\n    "dataSourceFunction": "Cmshelper::fetchOrderData",\r\n    "dataSourceCountFunction": "Cmshelper::fetchOrderDataCount",\r\n    "orderBy": {\r\n        "dBooking_Date": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "nNights_Stay",\r\n        "nAmount",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "OrderId",\r\n        "nCust_Id",\r\n        "destination",\r\n        "location",\r\n        "dArrival_Date",\r\n        "checkoutDate",\r\n        "dBooking_Date",\r\n        "vBooking_Details",\r\n        "nNights_Stay",\r\n        "nRooms",\r\n        "nAmount",\r\n        "nReserveModeAmount",\r\n        "nAdults",\r\n        "nChildren",\r\n        "vStatus"\r\n    ],\r\n    "columns": {\r\n        "OrderId": {\r\n            "name": "Order ID",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderId",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getInvoicePopupUrl"\r\n            }\r\n        },\r\n        "nBooking_Id": {\r\n            "name": "ID"\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",           \r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCustomerFromOrder",\r\n            "popupoptions": {\r\n                "type": "popup",\r\n                "customaction": "Cmshelper::getUserPopupUrl"\r\n            }\r\n        },\r\n        "dArrival_Date": {\r\n            "name": "Check In",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "checkoutDate": {\r\n            "name": "Check Out",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getCheckoutDate"\r\n        },\r\n        "dBooking_Date": {\r\n            "name": "Booking Date",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "vBooking_Details": {\r\n            "name": "Booking Details"\r\n        },\r\n        "nNights_Stay": {\r\n            "name": "Days",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nRooms": {\r\n            "name": "Rooms"\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount ($)",\r\n            "searchable": "true",\r\n            "sortable": true\r\n        },\r\n        "nReserveModeAmount": {\r\n            "name": "Advance Amount ($)"\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults"\r\n        },\r\n        "nChildren": {\r\n            "name": "Children"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "sortable": true,\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getOrderStatusChangeLink"\r\n        },\r\n        "destination": {\r\n            "name": "Destination",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchDestinationFromOrder"\r\n        },\r\n        "location": {\r\n            "name": "Location",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::fetchLocationFromOrder"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '1', 2, 'all'),
	(21, 4, 'Reservations', 'reservations', 'tbl_allotment', '{\r\n    "keyColumn": "nAllotment_Id",\r\n    "orderBy": {\r\n        "nAllotment_Id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "showColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "detailColumns": [\r\n        "nAllotment_Id",\r\n        "dDate",\r\n        "vStatus"\r\n    ],\r\n    "combineTables": {\r\n        "tbl_available_acco_type": {\r\n            "combineColumns": [\r\n                "nAt_Id",\r\n                "nLocation_Id"\r\n            ],\r\n            "combineReferenceColumn": "nAat_Id",\r\n            "combineTableForiegnKey": "nAat_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_locations": {\r\n                "combineColumns": [\r\n                    "nDestination_Id",\r\n                    "vLocation_Name"\r\n                ],\r\n                "combineReferenceColumn": "nLocation_Id",\r\n                "combineTableForiegnKey": "nLocation_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        },\r\n        "tbl_booking": {\r\n            "combineColumns": [\r\n                "nCust_Id"\r\n            ],\r\n            "combineReferenceColumn": "nBooking_Id",\r\n            "combineTableForiegnKey": "nBooking_Id",\r\n            "isPrimaryKey": "true",\r\n            "tbl_customers": {\r\n                "combineColumns": [\r\n                    "vFirstname",\r\n                    "vEmail"\r\n                ],\r\n                "combineReferenceColumn": "nCust_Id",\r\n                "combineTableForiegnKey": "nCust_Id",\r\n                "isPrimaryKey": "true"\r\n            }\r\n        }\r\n    },\r\n    "columns": {\r\n        "nAllotment_Id": {\r\n            "name": "ID",\r\n            "searchable": "true",\r\n            "sortable": "true"\r\n        },\r\n        "vLocation_Name": {\r\n            "name": "First Name",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "vDestination_Name": {\r\n            "name": "Destination"\r\n        },\r\n        "vAt_Name": {\r\n            "name": "Accomodation Type"\r\n        },\r\n        "dDate": {\r\n            "name": "Booking Details",\r\n            "searchable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "M,j, Y"\r\n        },\r\n        "vFirstname": {\r\n            "name": "Nights Stay",\r\n            "searchable": "true"\r\n        },\r\n        "vEmail": {\r\n            "name": "Amount"\r\n        },\r\n        "vStatus": {\r\n            "name": "Status",\r\n            "searchable": "true"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(22, 4, 'Accomodation', 'location_accomodation_tag', 'tbl_available_acco_type', '{\r\n    "keyColumn": "nAat_Id",\r\n    "detailHeaderColumns": [\r\n        "nAat_Id"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nAat_Id": "DESC"\r\n    },\r\n    "reference": {\r\n        "referenceTable": " tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "listColumns": [\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAmount",\r\n        "nRoom",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "detailColumns": [\r\n        "nAat_Id",\r\n        "nLocation_Id",\r\n        "vCode",\r\n        "nAt_Id",\r\n        "nAdults",\r\n        "nChildren",\r\n        "nAmount",\r\n        "nRoom",\r\n        "file_id",\r\n        "vActive"\r\n    ],\r\n    "columns": {\r\n        "nAat_Id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nAt_Id": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": "Cmshelper::getAllAccomodationTypes",\r\n                "source_type": "function",\r\n                "label": "Accomodation Type",\r\n                "class": "select"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": " tbl_accomodation_types",\r\n                "externalColumn": "nAt_Id",\r\n                "externalShowColumn": "vAt_Name"\r\n            }\r\n        },\r\n        "vCode": {\r\n            "name": "Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Code",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAdults": {\r\n            "name": "Adults",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Adults",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nChildren": {\r\n            "name": "Children",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Children",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nAmount": {\r\n            "name": "Amount",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Amount",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nRoom": {\r\n            "name": "Room",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Room",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "deactive": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "relations": {\r\n        "accomodation_offer_tag": {\r\n            "name": "Offers",\r\n            "section": "accomodation_offer_tag",\r\n            "child_table": "tbl_offer_price",\r\n            "parent_join_column": "nAat_Id ",\r\n            "child_join_column": "nAat_Id "\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 0, 'all'),
	(23, 4, 'Banners', 'banners', 'tbl_Banners', '{\r\n    "keyColumn": "nBId",\r\n    "detailHeaderColumnPrefix": "Banner: ",\r\n    "detailHeaderColumns": [\r\n        "vName"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nBId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive"\r\n    ],\r\n    "showColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "detailColumns": [\r\n        "nBId",\r\n        "vName",\r\n        "vlocUrl",\r\n        "vLocation",\r\n        "vActive",\r\n        "file_id",\r\n        "nDate"\r\n    ],\r\n    "columns": {\r\n        "nBId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "vName": {\r\n            "name": "Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Name",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "vlocUrl": {\r\n            "name": "Target URL",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Target URL",\r\n                "class": "textbox",\n"hint":"Website to be displayed on clicking the image. Eg: www.example.com "\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n"hint":"Ideal size 1366 x 500. Allowed file types are jpg,jpeg,gif and png."\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "nDate": {\r\n            "name": "Added Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vLocation": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Location",\r\n                "class": "select",\r\n                "hint":"Location where the banner shows, either home page or inner pages",\r\n                "enumvalues": {\r\n                    "Home": "Home Page",\r\n                    "Sub": "Sub Page"\r\n                }\r\n            }\r\n        },\r\n        "vActive": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeBannerStatus",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "In active"\r\n                },\r\n                "buttonColors": {\r\n                    "1": "green",\r\n                    "0": "red"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "customActions": {\r\n        "beforeEditRecord": "Cmshelper::unsetDateField",\r\n        "afterAddRecord": "Cmshelper::updateBannerAddedDate"\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 2, 'all'),
	(24, 6, 'News', 'news', 'tbl_News', '{\r\n"detailHeaderColumns":[ "nid"],\r\n    "keyColumn": "nid",\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "nid": "ASC"\r\n    },\r\n    "listColumns": [\r\n        \r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "exp_date",\r\n        "active"\r\n    ],\r\n    "showColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "detailColumns": [\r\n        "nid",\r\n        "ntitle",\r\n        "ndescription",\r\n        "nposition",\r\n        "active",\r\n        "exp_date",\r\n        "file_id"\r\n    ],\r\n    "columns": {\r\n        "nid": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "ntitle": {\r\n            "name": "Title",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "ndescription": {\r\n            "name": "Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Description",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "nposition": {\r\n            "name": "Position",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Position",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "active": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Active",\r\n                    "0": "Deactive"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "exp_date": {\r\n            "name": "Expiry Date",\r\n            "sortable": "true",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Expiry Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "Y-m-d"\r\n            }\r\n        },\r\n        "file_id": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint":"Ideal size 1366 x 500. Allowed file types are jpeg,jpg,png and gif"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        }\r\n    },\r\n   \r\n    "customActions": {\r\n        "afterAddRecord": "Cmshelper::updateNewsDate" ,\r\n "afterEditRecord": "Cmshelper::updateNewsExpireDate"           \r\n    },\r\n\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 2, 'all'),
	(25, 1, 'Payments', 'payments', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"payments","module":"default"}\r\n', '1', 6, 'all'),
	(36, 4, 'Accomodations', 'location_accomodation_tag1', 'tbl_available_acco_type', '{"customAction":"true","controller":"cmshelper","method":"locationbasedaccomodations","module":"default"}\r\n', '0', 0, 'all'),
	(37, 5, 'Sales Report', 'sales_report', 'tbl_payment', '{"customAction":"true","controller":"cmshelper","method":"salesreport","module":"default"}\r\n', '1', 1, 'all'),
	(38, 5, 'Booking Report', 'booking_report', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"bookingreport","module":"default"}\r\n', '1', 2, 'all'),
	(39, 5, 'Customer Report', 'customer_report', 'tbl_customers', '{"customAction":"true","controller":"cmshelper","method":"customerreport","module":"default"}\r\n', '1', 3, 'all'),
	(40, 5, 'Inventory Report', 'inventory_report', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"inventoryreport","module":"default"}\r\n', '1', 4, 'all'),
	(41, 7, 'Manage Roles', 'manage_roles', 'cms_roles', '{"customCmsAction":"true","controller":"cms","method":"manageroles","module":"cms"}', '1', 2, 'all'),
	(42, 7, 'Manage Privileges ', 'cms_privileges', 'cms_privileges', '{"customCmsAction":"true","controller":"cms","method":"manageprivilege","module":"cms"}\r\n', '1', 2, 'all'),
	(43, 7, 'Manage Admin Users', 'cms_users', 'cms_users', '{"customCmsAction":"true","controller":"cms","method":"manageusers","module":"cms"}', '1', 1, 'all'),
	(44, 1, 'Offline Bookings', 'booking', 'tbl_booking', '{"customAction":"true","controller":"cmshelper","method":"booking","module":"default"}\r\n', '1', 6, 'all'),
	(26, 4, 'Accomodation Offers', 'accomodation_offer_tag', 'tbl_offer_price', '{\r\n    "keyColumn": "offer_price_id",\r\n    "reference": {\r\n        "referenceTable": "tbl_available_acco_type",\r\n        "referenceColumn": "nAat_Id",\r\n        "referenceTableForiegnKey": "nAat_Id"\r\n    },\r\n    "orderBy": {\r\n        "offer_price_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "offer_price_id",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "showColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "offer_price_id",\r\n        "nAat_Id ",\r\n        "offer_start_date ",\r\n        "offer_end_date",\r\n        "price",\r\n        "published",\r\n        "created_on"\r\n    ],\r\n    "columns": {\r\n        "offer_price_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nAat_Id ": {\r\n            "name": "Accomodation Type",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_accomodation_types",\r\n                "externalColumn": "nAat_Id",\r\n                "externalShowColumn": "nAat_Id"\r\n            }\r\n        },\r\n        "price": {\r\n            "name": "Price",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "textbox",\r\n                "label": "Price",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "offer_start_date": {\r\n            "name": "Offer Start Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer Start Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "offer_end_date": {\r\n            "name": "Offer End Date",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "datepicker",\r\n                "label": "Offer End Date",\r\n                "class": "textbox",\r\n                "dbFormat": "date",\r\n                "displayFormat": "d/m/Y"\r\n            }\r\n        },\r\n        "published": {\r\n            "name": "Published",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Published",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "1": "Yes",\r\n                    "0": "No"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "d/m/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '0', 0, 'all'),
	(35, 1, 'Affiliates', 'referrals', 'tbl_affiliates', '{\r\n    "keyColumn": "aff_id",\r\n    "detailHeaderColumnPrefix": "Affiliate: ",\r\n    "detailHeaderColumns": [\r\n        "aff_fname"\r\n    ],\r\n    "orderBy": {\r\n        "aff_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "aff_fname",\r\n        "aff_email",\r\n        "aff_regdate",\r\n        "amount",\r\n        "settled"\r\n    ],\r\n    "detailColumns": [\r\n        "aff_id",\r\n        "aff_fname",\r\n        "aff_email",\r\n        "aff_regdate",\r\n        "amount",\r\n        "settled"\r\n    ],\r\n    "columns": {\r\n        "aff_id": {\r\n            "name": "ID"\r\n        },\r\n        "aff_fname": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        "aff_email": {\r\n            "name": "Email",\r\n            "sortable": "true",\r\n            "searchable": "true"\r\n        },\r\n        \r\n        "aff_regdate": {\r\n            "name": "Joining Date",\r\n             "customColumn": "true",\r\n           "customaction": "Utils::getUnixDateFormat"\r\n        },\r\n        "amount": {\r\n            "name": "Amount",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getTotalAffilateAmount",\r\n            "listHeaderPostfix": "($)"\r\n        },\r\n        "settled": {\r\n            "name": "Settled",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getSettledStatus"\r\n        }\r\n        \r\n    },\r\n    "relations": {\r\n        "customer": {\r\n            "name": "Customer Count",\r\n            "section": "affiliate_customers",\r\n            "child_table": "tbl_affiliate_useraction",\r\n            "parent_join_column": "aff_id",\r\n            "child_join_column": "ua_aff_id"\r\n        }\r\n    },\r\n    \r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '1', 9, 'all'),
	(27, 4, 'Reviews', 'location_review_tag', 'tbl_rating', '{\r\n    "keyColumn": "nRatingId",\r\n    "detailHeaderColumns": [\r\n        "nRatingId"\r\n    ],\r\n    "handleFile": "true",\r\n    "reference": {\r\n        "referenceTable": "tbl_locations",\r\n        "referenceColumn": "nLocation_Id",\r\n        "referenceTableForiegnKey": "nLocation_Id"\r\n    },\r\n    "orderBy": {\r\n        "nRatingId": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "nCust_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "showColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "detailColumns": [\r\n        "nRatingId",\r\n        "nCust_Id",\r\n        "nLocation_Id",\r\n        "nMarks",\r\n        "vFeedbackTitle",\r\n        "vFeedback",\r\n        "dPosted_Date",\r\n        "vRate_Status",\r\n        "vFeedback_Status"\r\n    ],\r\n    "columns": {\r\n        "nRatingId": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "nCust_Id": {\r\n            "name": "Customer",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "nLocation_Id": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_locations",\r\n                "externalColumn": "nLocation_Id",\r\n                "externalShowColumn": "vLocation_Name"\r\n            }\r\n        },\r\n        "nMarks": {\r\n            "name": "Marks",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedbackTitle": {\r\n            "name": "Title",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "vFeedback": {\r\n            "name": "Feedback",\r\n            "sortable": "true"\r\n            \r\n        },\r\n        "dPosted_Date": {\r\n            "name": "Posted On",\r\n            "sortable": "true",\r\n            "dbFormat": "datetime",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "vRate_Status": {\r\n            "name": "Rating Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Rating Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        },\r\n        "vFeedback_Status": {\r\n            "name": "Feedback Status",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Feedback Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "active": "Active",\r\n                    "inactive": "Inactive"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '0', 0, 'all'),
	(28, 6, 'Mail Templates', 'mail_templates', 'tbl_mail_template', '{\r\n    "keyColumn": "id",\r\n    "detailHeaderColumns": [\r\n        "id"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_status"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "mail_template_name",\r\n        "mail_template_sub",\r\n        "mail_template_body",\r\n        "mail_template_status",\r\n        "created_on "\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "mail_template_name": {\r\n            "name": "Name",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "disabled",\r\n                "label": "Template Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_sub": {\r\n            "name": "Subject",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Subject",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_body": {\r\n            "name": "Body",\r\n            "editoptions": {\r\n                "type": "htmlEditor",\r\n                "label": "Body",\r\n                "class": "textarea",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "mail_template_status": {\r\n            "name": "Status",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeMailTemplateStatus",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        },\r\n        "created_on": {\r\n            "name": "Created On",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 1, 'all'),
	(29, 6, 'Meta Tags', 'meta_tags', 'fw_metadata', '{\r\n "keyColumn": "id",\r\n "detailHeaderColumnPrefix": "Meta Tag : ",\r\n    "detailHeaderColumns": [\r\n        "url"\r\n    ],\r\n    "orderBy": {\r\n        "id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "url",\r\n        "title",\r\n        "keyword"\r\n    ],\r\n    "showColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "detailColumns": [\r\n        "id",\r\n        "url",\r\n        "title",\r\n        "keyword",\r\n        "description"\r\n    ],\r\n    "columns": {\r\n        "id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "title": {\r\n            "name": "Meta Title",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Meta Title",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "keyword": {\r\n            "name": "Meta Keywords",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Keywords",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "description": {\r\n            "name": "Meta Description",\r\n            "editoptions": {\r\n                "type": "textarea",\r\n                "label": "Meta Description",\r\n                "class": "textarea"\r\n            }\r\n        },\r\n        "url": {\r\n            "name": "Page Url",\r\n            "sortable": "true",\r\n            "searchable": "searchable",\r\n            "editoptions": {\r\n                "label": "Page Url",\r\n                "type": "textbox",\r\n                "class": "textbox",\r\n                "hint":"<b>Url combinations can be : </b><br/><b style=\'color:red\'> /abc/</b> [exact location abc after your domain name] eg : www.domainname.com/abc/ ,<br/> <b style=\'color:red\'>/abc/* </b> [any combination after location abc after your domain name] eg : www.domainname.com/abc/test1,<br/> <b style=\'color:red\'>* </b>[default value] ",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 3, 'all'),
	(30, 1, 'Reserved Rooms', 'reserved_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"reservedrooms","module":"default"}\r\n', '1', 8, 'all'),
	(31, 1, 'Blocked Rooms', 'blocked_rooms', 'tbl_allotment', '{"customAction":"true","controller":"cmshelper","method":"blockedrooms","module":"default"}\r\n', '1', 7, 'all'),
	(49, 6, 'Admin Help Listings', 'admin_help_listings', 'tbl_Help', '{"customAction":"true","controller":"cmshelper","method":"adminhelplistings","module":"default"}\r\n', '1', 0, 'all'),
	(33, 4, 'Group Discount', 'group_discount', 'tbl_group_discounts', '{"customAction":"true","controller":"cmshelper","method":"groupdiscount","module":"default"}\r\n', '1', 7, 'all'),
	(48, 1, 'Cancelled Orders', 'cancelled_orders', 'tbl_payments', '{"customAction":"true","controller":"cmshelper","method":"cancelledpayments","module":"default"}\r\n', '1', 3, 'all'),
	(46, 6, 'Admin Help Content', 'admin_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"adminhelpcontent","module":"default"}\r\n', '1', 6, 'all'),
	(47, 6, 'Client Help Content', 'client_help_content', 'tbl_HelpCategory', '{"customAction":"true","controller":"cmshelper","method":"clienthelpcontent","module":"default"}\r\n', '1', 7, 'all'),
	(50, 3, 'Layout', 'cms_layout', 'none', '{\r\n    "headerLinks": {\r\n        "helpListing": {\r\n            "title": "Help",\r\n            "linkSource": "Cmshelper::getAdminHelpListingPopupUrl"\r\n        },\r\n        "quickStartGuide": {\r\n            "title": "Quick Start Guide",\r\n            "linkSource": "Cmshelper::getQuickStartGuidePopupUrl",\r\n            "target": "popup"\r\n        }\r\n    }\r\n}', '0', 4, 'all'),
	(51, 1, 'Affiliate Links', 'affiliatelinks', ' tbl_affiliates_links', '{\r\n    "keyColumn": "link_id",\r\n    "detailHeaderColumnPrefix": "Link: ",\r\n    "detailHeaderColumns": [\r\n        "link_name"\r\n    ],\r\n    "handleFile": "true",\r\n    "orderBy": {\r\n        "link_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_title"\r\n    ],\r\n    "showColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image"\r\n    ],\r\n    "detailColumns": [\r\n        "link_id",\r\n        "link_name",\r\n        "link_status",\r\n        "link_type",\r\n        "link_image",\r\n        "link_title"\r\n    ],\r\n    "columns": {\r\n        "link_id": {\r\n            "name": "ID",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "link_title": {\r\n            "name": "Link Image",\r\n            "customColumn": "true",\r\n            "customaction": "Cmshelper::getaffiliatelinks"\r\n        },\r\n        "link_name": {\r\n            "name": "Link Name",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Link Title",\r\n                "class": "textbox"\r\n            }\r\n        },\r\n        "link_image": {\r\n            "name": "Image",\r\n            "sortable": "true",\r\n            "editoptions": {\r\n                "type": "file",\r\n                "label": "Image",\r\n                "class": "file",\r\n                "hint": "Ideal size 240 x 50"\r\n            },\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_files",\r\n                "externalColumn": "file_id",\r\n                "externalShowColumn": "file_id"\r\n            }\r\n        },\r\n        "link_type": {\r\n            "name": "Location",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Link Type",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Image Link",\r\n                    "1": "Text Link"\r\n                }\r\n            }\r\n        },\r\n        "link_status": {\r\n            "name": "Status",\r\n            "searchable": "true",\r\n            "editoptions": {\r\n                "validations": [\r\n                    "required"\r\n                ],\r\n                "type": "select",\r\n                "source": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                },\r\n                "source_type": "array",\r\n                "label": "Status",\r\n                "class": "select",\r\n                "enumvalues": {\r\n                    "0": "Deactive",\r\n                    "1": "Active"\r\n                }\r\n            },\r\n            "listoptions": {\r\n                "type": "button",\r\n                "customaction": "Cmshelper::changeAffiliateLinkStatus",\r\n                "enumvalues": {\r\n                    "0": "Inactive",\r\n                    "1": "Active"\r\n                },\r\n                "buttonColors": {\r\n                    "0": "red",\r\n                    "1": "green"\r\n                }\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "view",\r\n        "edit",\r\n        "delete",\r\n        "add"\r\n    ]\r\n}', '1', 10, 'all'),
	(52, 1, 'Affiliate Customers', 'affiliate_customers', 'tbl_affiliate_useraction', '{\r\n    "keyColumn": "ua_id",\r\n    "reference": {\r\n        "referenceTable": " tbl_affiliates",\r\n        "referenceColumn": "ua_aff_id",\r\n        "referenceTableForiegnKey": "aff_id"\r\n    },\r\n    "detailHeaderColumnPrefix": "Customer: ",\r\n    "detailHeaderColumns": [\r\n        "ua_userid"\r\n    ],\r\n    \r\n    "orderBy": {\r\n        "ua_id": "DESC"\r\n    },\r\n    "listColumns": [\r\n        "ua_userid",\r\n        "ua_referalcharge",\r\n        "ua_paystatus",\r\n        "ua_date_settled"\r\n    ],\r\n    "detailColumns": [\r\n        "ua_id",\r\n        "ua_userid",\r\n        "ua_referalcharge",\r\n        "ua_paystatus",\r\n        "ua_date_settled"\r\n    ],\r\n    "columns": {\r\n        "ua_id": {\r\n            "name": "ID"\r\n        },\r\n        "ua_userid": {\r\n            "name": "Customer Name",\r\n            "sortable": "true",\r\n            "searchable": "true",\r\n            "external": "true",\r\n            "externalOptions": {\r\n                "externalTable": "tbl_customers",\r\n                "externalColumn": "nCust_Id",\r\n                "externalShowColumn": "vFirstname"\r\n            }\r\n        },\r\n        "ua_referalcharge": {\r\n            "name": "Referal Charge"\r\n        },\r\n\r\n        "ua_date_settled": {\r\n            "name": "Settled Date",\r\n            "dbFormat": "date",\r\n            "displayFormat": "m/d/Y"\r\n        },\r\n        "ua_paystatus": {\r\n            "name": "Status",\r\n            "editoptions": {\r\n                "enumvalues": {\r\n                        "1": "Active",\r\n                        "2": "Inactive"\r\n                }\r\n            }\r\n        }\r\n\r\n    },\r\n\r\n    "opertations": [\r\n        "view"\r\n    ]\r\n}', '0', 0, 'all'),
	(56, 4, 'Seasonal_rates', 'location_accomodation_seasonal_rates', 'tbl_available_acco_type', '{"customAction":"true","controller":"cmshelper","method":"locationbasedaccomodationsseasonalrates","module":"default"}\r\n', '0', 0, 'all'),
	(57, 4, 'Currencies', 'currency', 'tbl_currency_master', '{\r\n "keyColumn": "currency_id",\r\n "detailHeaderColumnPrefix": "Currency : ",\r\n    "detailHeaderColumns": [\r\n        "Currency Name"\r\n    ],\r\n    "orderBy": {\r\n        "currency_id": "ASC"\r\n    },\r\n    "listColumns": [\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n       "status"\r\n    ],\r\n    "showColumns": [\r\n        "currency_id",\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n        "status"\r\n    ],\r\n    "detailColumns": [\r\n       "currency_id",\r\n        "currency_name",\r\n        "currency_code",\r\n        "currency_symbol",\r\n        "status"\r\n    ],\r\n    "columns": {\r\n        "currency_id": {\r\n            "name": "ID",\r\n            "editoptions": {\r\n                "type": "hidden"\r\n            }\r\n        },\r\n        "currency_name": {\r\n            "name": "Currency Name",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Name",\r\n                "class": "textbox",\r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "currency_code": {\r\n            "name": "Currency Code",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Code",\r\n                "class": "textbox",\r\n                 "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "currency_symbol": {\r\n            "name": "Currency Symbol",\r\n            "editoptions": {\r\n                "type": "textbox",\r\n                "label": "Currency Symbol",\r\n                "class": "textbox",\r\n "hint":"It can be either a currency symbol like $ (dollar) or its numeric code  or its hexadecimal code ",\r\n                 "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        },\r\n        "status": {\r\n            "name": "Status",\r\n           \r\n            "editoptions": {\r\n                "label": "Status",\r\n                "type": "select",\r\n                  "source": {\r\n                    "active": "Active",\r\n                    "deactive": "Inactive"\r\n                },\r\n\r\n               "source_type": "array",\r\n\r\n                "class": "select",\r\n               \r\n                "validations": [\r\n                    "required"\r\n                ]\r\n            }\r\n        }\r\n    },\r\n    "opertations": [\r\n        "add",\r\n        "view",\r\n        "edit",\r\n        "delete"\r\n    ]\r\n}', '1', 6, 'all');

INSERT INTO `tbl_lookup` (`vLookUp_Name`, `vLookUp_Value`, `settinglabel`, `groupLabel`, `type`) VALUES
	('currency', '1', 'Choose Default Currency', 'Payment', 'selectbox'),
	('enablebluepay', 'N', 'Enable BluePayTest Mode', 'Payment', ''),
	('bluepaypayid', '', 'BluePay Login Id', 'Payment', ''),
	('bluepaysecretkey', '', 'BluePay Secret Key', 'Payment', ''),
	('bluepaydemo', 'Y', 'Enable BluePay Demo', 'Payment', ''),
	('cenable_paypal_pro', 'N', 'Enable PayPal Pro', 'Payment', ''),
	('vpaypal_pro_test_mode', 'N', 'Enable PayPal Pro Test Mode', 'Payment', ''),
	('vpaypalprosignature', '', 'PayPal Pro Signature', 'Payment', ''),
	('vpaypalprousername', '', 'PayPal Pro UserName', 'Payment', ''),
	('vpaypalpropassword', '', 'PayPal Pro Password', 'Payment', ''),
	('vpaypalprobncode', '', 'PayPal Pro BN code', 'Payment', ''),
	('embed_label', 'Search', 'Label', 'Embed Code', 'textbox'),
	('embed_bg_color', '#C0C0C0', 'Background Color', 'Embed Code', 'textbox'),
	('embed_color', '#FFFFFF', 'Color', 'Embed Code', 'textbox'),
	('embed_div_id', 'embedSearch', 'Div Id', 'Embed Code', 'textbox'),
	('embed_display_style', '2', 'Display style', 'Embed Code', 'textbox'),
	('embed_url', 'http://localhost/reservelogic', 'Url', 'Embed Code', 'textbox'),
	('embed_operation_mode', '3', 'Operation Mode', 'Embed Code', 'textbox'),
	('embed_new_tab', '1', 'Enable new tab', 'Embed Code', 'textbox'),
	('payment_gateway', 'authorize', 'Choose credit card', 'Payment', '');
        

INSERT INTO `tbl_currency_master` (`currency_id`, `currency_name`, `currency_code`, `currency_symbol`, `status`) VALUES
	(1, 'US Dollar', 'USD', '$', 'active');



